/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class CompactingUpgradeItem extends Internal.UpgradeItemBase<Internal.CompactingUpgradeWrapper> {
        constructor(shouldCompactThreeByThree: boolean, filterSlotCount: Internal.IntSupplier_, upgradeTypeLimitConfig: any_)
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getFilterSlotCount(): number;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        shouldCompactThreeByThree(): boolean;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getInventoryColumnsTaken(): number;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        getType(): Internal.UpgradeType<Internal.CompactingUpgradeWrapper>;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        set digSpeed(speed: number)
        get filterSlotCount(): number
        set attackSpeed(attackSpeed: number)
        get inventoryColumnsTaken(): number
        get creativeTab(): string
        get type(): Internal.UpgradeType<Internal.CompactingUpgradeWrapper>
        set armorKnockbackResistance(knockbackResistance: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type CompactingUpgradeItem_ = CompactingUpgradeItem;
    interface ObjectSet <K> extends Internal.Set<K>, Internal.ObjectCollection<K> {
        abstract addAll(arg0: Internal.Collection_<K>): boolean;
        of<K>(arg0: K, arg1: K, arg2: K): this;
        abstract isEmpty(): boolean;
        of<K>(arg0: K, arg1: K): this;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        parallelStream(): Internal.Stream<K>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        abstract contains(arg0: any): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        iterator(): Internal.Iterator<any>;
        abstract toArray<T>(arg0: T[]): T[];
        forEach(arg0: Internal.Consumer_<K>): void;
        abstract remove(arg0: any): boolean;
        abstract toArray(): any[];
        removeIf(arg0: Internal.Predicate_<K>): boolean;
        of<K>(): this;
        abstract size(): number;
        abstract hashCode(): number;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        spliterator(): Internal.Spliterator<any>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        of<K>(...arg0: K[]): this;
        abstract clear(): void;
        of<K>(arg0: K): this;
        abstract equals(arg0: any): boolean;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        abstract add(arg0: K): boolean;
        stream(): Internal.Stream<K>;
        get empty(): boolean
    }
    type ObjectSet_<K> = ObjectSet<K>;
    class TextureManager implements Internal.Tickable, Internal.PreparableReloadListener, Internal.AutoCloseable, Internal.IdentifiableResourceReloadListener {
        constructor($$0: Internal.ResourceManager_)
        bindForSetup($$0: ResourceLocation_): void;
        getTexture($$0: ResourceLocation_, $$1: Internal.AbstractTexture_): Internal.AbstractTexture;
        release($$0: ResourceLocation_): void;
        getFabricDependencies(): Internal.Collection<any>;
        tick(): void;
        close(): void;
        getName(): string;
        register($$0: ResourceLocation_, $$1: Internal.AbstractTexture_): void;
        getTexture($$0: ResourceLocation_): Internal.AbstractTexture;
        register($$0: string, $$1: Internal.DynamicTexture_): ResourceLocation;
        dumpAllSheets($$0: Internal.Path_): void;
        preload($$0: ResourceLocation_, $$1: Internal.Executor_): Internal.CompletableFuture<void>;
        getFabricId(): ResourceLocation;
        reload($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        get fabricDependencies(): Internal.Collection<any>
        get name(): string
        get fabricId(): ResourceLocation
        static readonly INTENTIONAL_MISSING_TEXTURE: ResourceLocation;
        readonly byPath: Internal.Map<ResourceLocation, Internal.AbstractTexture>;
    }
    type TextureManager_ = TextureManager;
    class FireworkStarItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        static appendHoverText($$0: Internal.CompoundTag_, $$1: Internal.List_<net.minecraft.network.chat.Component>): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type FireworkStarItem_ = FireworkStarItem;
    class DesertPyramidStructure extends Internal.SinglePieceStructure {
        constructor($$0: Internal.Structure$StructureSettings_)
        static readonly CODEC: Internal.Codec<Internal.DesertPyramidStructure>;
    }
    type DesertPyramidStructure_ = DesertPyramidStructure;
    abstract class GrowingPlantBodyBlock extends Internal.GrowingPlantBlock implements Internal.BonemealableBlock {
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type GrowingPlantBodyBlock_ = GrowingPlantBodyBlock;
    interface ICrashAdvancement {
        abstract railways$awardCrashAdvancements(): void;
        (): void;
    }
    type ICrashAdvancement_ = ICrashAdvancement;
    abstract class ItemCastingRecipe extends Internal.AbstractCastingRecipe implements Internal.IDisplayableCastingRecipe {
        constructor(type: Internal.RecipeType_<any>, id: ResourceLocation_, group: string, cast: Internal.Ingredient_, fluid: slimeknights.mantle.recipe.ingredient.FluidIngredient_, result: any_, coolingTime: number, consumed: boolean, switchSlots: boolean)
        getGroup(): string;
        getCoolingTime(): number;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        assemble(inv: Internal.ICastingContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getCastItems(): Internal.List<Internal.ItemStack>;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        getMod(): string;
        getOutput(): Internal.ItemStack;
        isSpecial(): boolean;
        getRemainingItems($$0: Internal.ICastingContainer_): Internal.NonNullList<Internal.ItemStack>;
        matches(inv: Internal.ICastingContainer_, worldIn: Internal.Level_): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        getFluids(): Internal.List<Internal.FluidStack>;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        static calcCoolingTime(fluid: Internal.FluidStack_): number;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        hasCast(): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getFluid(): slimeknights.mantle.recipe.ingredient.FluidIngredient;
        static calcCoolingTime(temperature: number, amount: number): number;
        get group(): string
        get coolingTime(): number
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get castItems(): Internal.List<Internal.ItemStack>
        get mod(): string
        get output(): Internal.ItemStack
        get special(): boolean
        get fluids(): Internal.List<Internal.FluidStack>
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get fluid(): slimeknights.mantle.recipe.ingredient.FluidIngredient
    }
    type ItemCastingRecipe_ = ItemCastingRecipe;
    class MoltenNecromiumFluid$Flowing extends Internal.MoltenNecromiumFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenNecromiumFluid$Flowing_ = MoltenNecromiumFluid$Flowing;
    interface FileStoreAttributeView extends Internal.AttributeView {
        abstract name(): string;
        (): string;
    }
    type FileStoreAttributeView_ = FileStoreAttributeView;
    class HosePulleyBlockEntity extends Internal.KineticBlockEntity implements Internal.SidedStorageBlockEntity {
        constructor(typeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getMovementSpeed(): number;
        getFluidStorage(face: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getItemStorage(side: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getInterpolatedOffset(pt: number): number;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get movementSpeed(): number
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
    }
    type HosePulleyBlockEntity_ = HosePulleyBlockEntity;
    interface ExtendingBufferBuilder {
        abstract iris$beginWithoutExtending(arg0: Internal.VertexFormat$Mode_, arg1: Internal.VertexFormat_): void;
        (arg0: Internal.VertexFormat$Mode, arg1: Internal.VertexFormat): void;
    }
    type ExtendingBufferBuilder_ = ExtendingBufferBuilder;
    class RenderStateShard$TransparencyStateShard extends Internal.RenderStateShard {
        constructor($$0: string, $$1: Internal.Runnable_, $$2: Internal.Runnable_)
        static getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        static getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
    }
    type RenderStateShard$TransparencyStateShard_ = RenderStateShard$TransparencyStateShard;
    class MerchantOffers extends Internal.ArrayList<Internal.MerchantOffer> {
        constructor()
        constructor($$0: Internal.CompoundTag_)
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.List<E>;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.List<E>;
        getRecipeFor($$0: Internal.ItemStack_, $$1: Internal.ItemStack_, $$2: number): Internal.MerchantOffer;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.List<E>;
        parallelStream(): Internal.Stream<Internal.MerchantOffer>;
        createTag(): Internal.CompoundTag;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.List<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.List<E>;
        stream(): Internal.Stream<Internal.MerchantOffer>;
        static of<E>(arg0: E): Internal.List<E>;
        static of<E>(): Internal.List<E>;
        static of<E>(...arg0: E[]): Internal.List<E>;
        writeToStream($$0: Internal.FriendlyByteBuf_): void;
        static of<E>(arg0: E, arg1: E): Internal.List<E>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        reversed(): Internal.SequencedCollection<any>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.List<E>;
        static createFromStream($$0: Internal.FriendlyByteBuf_): Internal.MerchantOffers;
    }
    type MerchantOffers_ = MerchantOffers;
    class NetherrackBlock extends Internal.Block implements Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type NetherrackBlock_ = NetherrackBlock;
    class RegistryInfo <T> implements Internal.Iterable<Internal.BuilderBase<T>>, Internal.TypeWrapperFactory<T> {
        forEach(arg0: Internal.Consumer_<Internal.BuilderBase<T>>): void;
        iterator(): Internal.Iterator<Internal.BuilderBase<T>>;
        addType(type: string, builderType: Internal.BuilderBase<T>, factory: Internal.BuilderFactory_, isDefault: boolean): void;
        getId(value: T): ResourceLocation;
        addType(type: string, builderType: Internal.BuilderBase<T>, factory: Internal.BuilderFactory_): void;
        wrap(cx: Internal.Context_, o: any): T;
        languageKeyPrefix(prefix: string): this;
        getDefaultType(): Internal.BuilderType<any>;
        fireRegistryEvent(): void;
        bypassServerOnly(): this;
        noAutoWrap(): this;
        addBuilder(builder: Internal.BuilderBase_<T>): void;
        hasValue(id: ResourceLocation_): boolean;
        getValue(id: ResourceLocation_): T;
        static of(key: Internal.ResourceKey_<Internal.Registry<any>>): Internal.RegistryInfo<any>;
        entrySet(): Internal.Set<Internal.Map$Entry<Internal.ResourceKey<T>, T>>;
        static of<T>(key: Internal.ResourceKey_<Internal.Registry<any>>, type: T): Internal.RegistryInfo<T>;
        getVanillaRegistry(): Internal.Registry<T>;
        getArchitecturyRegistrar(): Internal.Registrar<T>;
        registerObjects(function_: Internal.RegistryCallback_<T>): number;
        spliterator(): Internal.Spliterator<Internal.BuilderBase<T>>;
        get defaultType(): Internal.BuilderType<any>
        get vanillaRegistry(): Internal.Registry<T>
        get architecturyRegistrar(): Internal.Registrar<T>
        static readonly STRUCTURE_SET: Internal.RegistryInfo<Internal.StructureSet>;
        static readonly AFTER_VANILLA: [];
        static readonly LOOT_SCORE_PROVIDER_TYPE: Internal.RegistryInfo<Internal.LootScoreProviderType>;
        static readonly RULE: Internal.RegistryInfo<Internal.Codec<any>>;
        static readonly DECORATED_POT_PATTERNS: Internal.RegistryInfo<string>;
        static readonly FLAT_LEVEL_GENERATOR_PRESET: Internal.RegistryInfo<Internal.FlatLevelGeneratorPreset>;
        static readonly LOOT_FUNCTION_TYPE: Internal.RegistryInfo<Internal.LootItemFunctionType>;
        static readonly RECIPE_SERIALIZER: Internal.RegistryInfo<Internal.RecipeSerializer<any>>;
        static readonly VILLAGER_PROFESSION: Internal.RegistryInfo<Internal.VillagerProfession>;
        static readonly LOOT_NBT_PROVIDER_TYPE: Internal.RegistryInfo<Internal.LootNbtProviderType>;
        static readonly ACTIVITY: Internal.RegistryInfo<Internal.Activity>;
        static readonly BLOCK: Internal.RegistryInfo<Internal.Block>;
        static readonly ENCHANTMENT: Internal.RegistryInfo<Internal.Enchantment>;
        static readonly FROG_VARIANT: Internal.RegistryInfo<Internal.FrogVariant>;
        static readonly MAP: {[key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>, [key: Internal.ResourceKey<any>]: Internal.RegistryInfo<any>};
        static readonly STRUCTURE_PLACEMENT_TYPE: Internal.RegistryInfo<Internal.StructurePlacementType<any>>;
        static readonly BANNER_PATTERN: Internal.RegistryInfo<Internal.BannerPattern>;
        static readonly STRUCTURE_PIECE: Internal.RegistryInfo<Internal.StructurePieceType>;
        static readonly BLOCK_PREDICATE_TYPE: Internal.RegistryInfo<Internal.BlockPredicateType<any>>;
        static readonly ENTITY_TYPE: Internal.RegistryInfo<Internal.EntityType<any>>;
        static readonly ITEM: Internal.RegistryInfo<Internal.Item>;
        static readonly LOOT_SCORE_PROVIDER: Internal.RegistryInfo<Internal.LootScoreProviderType>;
        static readonly PLACEMENT_MODIFIER_TYPE: Internal.RegistryInfo<Internal.PlacementModifierType<any>>;
        static readonly PROCESSOR_LIST: Internal.RegistryInfo<Internal.StructureProcessorList>;
        static readonly NOISE: Internal.RegistryInfo<Internal.NormalNoise$NoiseParameters>;
        hasDefaultTags: boolean;
        static readonly SOUND_EVENT: Internal.RegistryInfo<Internal.SoundEvent>;
        static readonly FLOAT_PROVIDER_TYPE: Internal.RegistryInfo<Internal.FloatProviderType<any>>;
        static readonly SENSOR_TYPE: Internal.RegistryInfo<Internal.SensorType<any>>;
        static readonly VILLAGER_TYPE: Internal.RegistryInfo<Internal.VillagerType>;
        static readonly MATERIAL_RULE: Internal.RegistryInfo<Internal.Codec<any>>;
        static readonly BIOME_SOURCE: Internal.RegistryInfo<Internal.Codec<any>>;
        static readonly STRUCTURE: Internal.RegistryInfo<Internal.Structure>;
        static readonly INSTRUMENT: Internal.RegistryInfo<Internal.Instrument>;
        static readonly FLUID: Internal.RegistryInfo<Internal.Fluid>;
        static readonly POSITION_SOURCE_TYPE: Internal.RegistryInfo<Internal.PositionSourceType<any>>;
        static readonly STAT_TYPE: Internal.RegistryInfo<Internal.StatType<any>>;
        static readonly TEMPLATE_POOL: Internal.RegistryInfo<Internal.StructureTemplatePool>;
        readonly objectBaseClass: typeof any;
        static readonly GAME_EVENT: Internal.RegistryInfo<Internal.GameEvent>;
        static readonly MENU: Internal.RegistryInfo<Internal.MenuType<any>>;
        static readonly COMMAND_ARGUMENT_TYPE: Internal.RegistryInfo<Internal.ArgumentTypeInfo<any, any>>;
        static readonly STRUCTURE_POOL_ELEMENT: Internal.RegistryInfo<Internal.StructurePoolElementType<any>>;
        static readonly LOOT_NUMBER_PROVIDER_TYPE: Internal.RegistryInfo<Internal.LootNumberProviderType>;
        static readonly LOOT_NUMBER_PROVIDER: Internal.RegistryInfo<Internal.LootNumberProviderType>;
        static readonly STRUCTURE_PLACEMENT: Internal.RegistryInfo<Internal.StructurePlacementType<any>>;
        readonly key: Internal.ResourceKey<Internal.Registry<T>>;
        static readonly BLOCK_STATE_PROVIDER_TYPE: Internal.RegistryInfo<Internal.BlockStateProviderType<any>>;
        static readonly POTION: Internal.RegistryInfo<Internal.Potion>;
        static readonly CUSTOM_STAT: Internal.RegistryInfo<ResourceLocation>;
        static readonly CONDITION: Internal.RegistryInfo<Internal.Codec<any>>;
        readonly objects: Internal.Map<ResourceLocation, Internal.BuilderBase<T>>;
        static readonly INT_PROVIDER_TYPE: Internal.RegistryInfo<Internal.IntProviderType<any>>;
        static readonly CHUNK_GENERATOR: Internal.RegistryInfo<Internal.Codec<any>>;
        static readonly CAT_VARIANT: Internal.RegistryInfo<Internal.CatVariant>;
        static readonly TRIM_MATERIAL: Internal.RegistryInfo<Internal.TrimMaterial>;
        static readonly LOOT_CONDITION_TYPE: Internal.RegistryInfo<Internal.LootItemConditionType>;
        bypassServerOnly: boolean;
        static readonly CREATIVE_MODE_TAB: Internal.RegistryInfo<Internal.CreativeModeTab>;
        static readonly CONFIGURED_FEATURE: Internal.RegistryInfo<Internal.ConfiguredFeature<any, any>>;
        static readonly FEATURE: Internal.RegistryInfo<Internal.Feature<any>>;
        static readonly DAMAGE_TYPE: Internal.RegistryInfo<Internal.DamageType>;
        static readonly MATERIAL_CONDITION: Internal.RegistryInfo<Internal.Codec<any>>;
        static readonly TRUNK_PLACER_TYPE: Internal.RegistryInfo<Internal.TrunkPlacerType<any>>;
        static readonly DENSITY_FUNCTION: Internal.RegistryInfo<Internal.DensityFunction>;
        static readonly PAINTING_VARIANT: Internal.RegistryInfo<Internal.PaintingVariant>;
        static readonly LOOT_FUNCTION: Internal.RegistryInfo<Internal.LootItemFunctionType>;
        static readonly DIMENSION_TYPE: Internal.RegistryInfo<Internal.DimensionType>;
        static readonly LOOT_ENTRY: Internal.RegistryInfo<Internal.LootPoolEntryType>;
        static readonly MOB_EFFECT: Internal.RegistryInfo<Internal.MobEffect>;
        static readonly PLACEMENT_MODIFIER: Internal.RegistryInfo<Internal.PlacementModifierType<any>>;
        static readonly FEATURE_SIZE_TYPE: Internal.RegistryInfo<Internal.FeatureSizeType<any>>;
        static readonly SCHEDULE: Internal.RegistryInfo<Internal.Schedule>;
        static readonly HEIGHT_PROVIDER_TYPE: Internal.RegistryInfo<Internal.HeightProviderType<any>>;
        static readonly DIMENSION: Internal.RegistryInfo<Internal.Level>;
        static readonly NOISE_GENERATOR_SETTINGS: Internal.RegistryInfo<Internal.NoiseGeneratorSettings>;
        static readonly POS_RULE_TEST: Internal.RegistryInfo<Internal.PosRuleTestType<any>>;
        static readonly LOOT_NBT_PROVIDER: Internal.RegistryInfo<Internal.LootNbtProviderType>;
        static readonly CONFIGURED_CARVER: Internal.RegistryInfo<Internal.ConfiguredWorldCarver<any>>;
        static readonly WORLD_PRESET: Internal.RegistryInfo<Internal.WorldPreset>;
        static readonly LEVEL_STEM: Internal.RegistryInfo<Internal.LevelStem>;
        readonly types: Internal.Map<string, Internal.BuilderType<T>>;
        static readonly TREE_DECORATOR_TYPE: Internal.RegistryInfo<Internal.TreeDecoratorType<any>>;
        static readonly RECIPE_TYPE: Internal.RegistryInfo<Internal.RecipeType<any>>;
        static readonly MEMORY_MODULE_TYPE: Internal.RegistryInfo<Internal.MemoryModuleType<any>>;
        static readonly STRUCTURE_PROCESSOR: Internal.RegistryInfo<Internal.StructureProcessorType<any>>;
        static readonly STRUCTURE_TYPE: Internal.RegistryInfo<Internal.StructureType<any>>;
        static readonly DENSITY_FUNCTION_TYPE: Internal.RegistryInfo<Internal.Codec<any>>;
        static readonly ALL_BUILDERS: [];
        static readonly TRIM_PATTERN: Internal.RegistryInfo<Internal.TrimPattern>;
        static readonly FOLIAGE_PLACER_TYPE: Internal.RegistryInfo<Internal.FoliagePlacerType<any>>;
        static readonly CHAT_TYPE: Internal.RegistryInfo<Internal.ChatType>;
        static readonly NOISE_SETTINGS: Internal.RegistryInfo<Internal.NoiseGeneratorSettings>;
        autoWrap: boolean;
        static readonly ROOT_PLACER_TYPE: Internal.RegistryInfo<Internal.RootPlacerType<any>>;
        static readonly POINT_OF_INTEREST_TYPE: Internal.RegistryInfo<Internal.PoiType>;
        static readonly BIOME: Internal.RegistryInfo<Internal.Biome>;
        static readonly LOOT_ITEM: Internal.RegistryInfo<Internal.LootItemConditionType>;
        static readonly LOOT_POOL_ENTRY_TYPE: Internal.RegistryInfo<Internal.LootPoolEntryType>;
        static readonly MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST: Internal.RegistryInfo<Internal.MultiNoiseBiomeSourceParameterList>;
        languageKeyPrefix: string;
        static readonly PLACED_FEATURE: Internal.RegistryInfo<Internal.PlacedFeature>;
        static readonly CARVER: Internal.RegistryInfo<Internal.WorldCarver<any>>;
        static readonly BLOCK_ENTITY_TYPE: Internal.RegistryInfo<Internal.BlockEntityType<any>>;
        static readonly ATTRIBUTE: Internal.RegistryInfo<Internal.Attribute>;
        static readonly PARTICLE_TYPE: Internal.RegistryInfo<Internal.ParticleType<any>>;
        static readonly RULE_BLOCK_ENTITY_MODIFIER: Internal.RegistryInfo<Internal.RuleBlockEntityModifierType<any>>;
        static readonly CHUNK_STATUS: Internal.RegistryInfo<Internal.ChunkStatus>;
        static readonly RULE_TEST: Internal.RegistryInfo<Internal.RuleTestType<any>>;
    }
    type RegistryInfo_<T> = RegistryInfo<T>;
    interface SpriteContentsExtension {
        abstract getOrCreatePBRHolder(): Internal.PBRSpriteHolder;
        abstract getPBRHolder(): Internal.PBRSpriteHolder;
        get orCreatePBRHolder(): Internal.PBRSpriteHolder
        get PBRHolder(): Internal.PBRSpriteHolder
    }
    type SpriteContentsExtension_ = SpriteContentsExtension;
    interface AttachmentTarget {
        hasAttached(type: Internal.AttachmentType_<any>): boolean;
        setAttached<A>(type: Internal.AttachmentType_<A>, value: A): A;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttached<A>(type: Internal.AttachmentType_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        readonly NBT_ATTACHMENT_KEY: "fabric:attachments";
    }
    type AttachmentTarget_ = AttachmentTarget;
    class MangroveRootsBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type MangroveRootsBlock_ = MangroveRootsBlock;
    abstract class ByteBuffer extends Internal.Buffer implements Internal.Comparable<Internal.ByteBuffer> {
        abstract slice(arg0: number, arg1: number): this;
        alignedSlice(arg0: number): this;
        abstract getDouble(arg0: number): number;
        mismatch(arg0: Internal.ByteBuffer_): number;
        abstract putChar(arg0: number, arg1: string): this;
        static allocate(arg0: number): Internal.ByteBuffer;
        put(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        compareTo(arg0: any): number;
        get(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        abstract putDouble(arg0: number, arg1: number): this;
        abstract getFloat(arg0: number): number;
        order(): Internal.ByteOrder;
        abstract put(arg0: number): this;
        abstract putLong(arg0: number, arg1: number): this;
        abstract getChar(arg0: number): string;
        abstract asReadOnlyBuffer(): this;
        abstract asIntBuffer(): Internal.IntBuffer;
        put(arg0: number, arg1: Internal.ByteBuffer_, arg2: number, arg3: number): this;
        abstract asFloatBuffer(): Internal.FloatBuffer;
        put(arg0: number, arg1: number[]): this;
        abstract getInt(): number;
        get(arg0: number, arg1: number[]): this;
        abstract getChar(): string;
        put(arg0: Internal.ByteBuffer_): this;
        abstract putFloat(arg0: number, arg1: number): this;
        abstract putLong(arg0: number): this;
        flip(): this;
        abstract get(arg0: number): number;
        abstract getDouble(): number;
        abstract putFloat(arg0: number): this;
        abstract asLongBuffer(): Internal.LongBuffer;
        static wrap(arg0: number[]): Internal.ByteBuffer;
        abstract asShortBuffer(): Internal.ShortBuffer;
        abstract putChar(arg0: string): this;
        abstract asCharBuffer(): Internal.CharBuffer;
        abstract getLong(arg0: number): number;
        put(arg0: number[], arg1: number, arg2: number): this;
        abstract putShort(arg0: number, arg1: number): this;
        abstract compact(): this;
        static allocateDirect(arg0: number): Internal.ByteBuffer;
        abstract putShort(arg0: number): this;
        abstract getShort(arg0: number): number;
        order(arg0: Internal.ByteOrder_): this;
        get(arg0: number[], arg1: number, arg2: number): this;
        abstract getShort(): number;
        abstract getInt(arg0: number): number;
        put(arg0: number[]): this;
        alignmentOffset(arg0: number, arg1: number): number;
        abstract put(arg0: number, arg1: number): this;
        reset(): this;
        abstract putDouble(arg0: number): this;
        compareTo(arg0: Internal.ByteBuffer_): number;
        get(arg0: number[]): this;
        clear(): this;
        position(arg0: number): this;
        static wrap(arg0: number[], arg1: number, arg2: number): Internal.ByteBuffer;
        abstract asDoubleBuffer(): Internal.DoubleBuffer;
        abstract getLong(): number;
        abstract getFloat(): number;
        abstract get(): number;
        abstract putInt(arg0: number): this;
        abstract putInt(arg0: number, arg1: number): this;
        get "int"(): number
        get "char"(): string
        get "double"(): number
        get "short"(): number
        get "long"(): number
        get "float"(): number
    }
    type ByteBuffer_ = ByteBuffer;
    interface LootContextAccessor {
        abstract getParams(): Internal.LootParams;
        get params(): Internal.LootParams
        (): Internal.LootParams_;
    }
    type LootContextAccessor_ = LootContextAccessor;
    class EyebulbBlock extends Internal.DoublePlantBlockBOP {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type EyebulbBlock_ = EyebulbBlock;
    class ServerboundClientInformationPacket extends Internal.Record implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: string, $$1: number, $$2: Internal.ChatVisiblity_, $$3: boolean, $$4: number, $$5: Internal.HumanoidArm_, $$6: boolean, $$7: boolean)
        constructor($$0: Internal.FriendlyByteBuf_)
        chatColors(): boolean;
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        language(): string;
        handle($$0: Internal.ServerGamePacketListener_): void;
        modelCustomisation(): number;
        viewDistance(): number;
        mainHand(): Internal.HumanoidArm;
        chatVisibility(): Internal.ChatVisiblity;
        isSkippable(): boolean;
        textFilteringEnabled(): boolean;
        allowsListing(): boolean;
        get skippable(): boolean
        static readonly MAX_LANGUAGE_LENGTH: 16;
    }
    type ServerboundClientInformationPacket_ = ServerboundClientInformationPacket;
    class DelightFoodItem extends Internal.Item {
        constructor(settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type DelightFoodItem_ = DelightFoodItem;
    interface IInventoryHolder {
        shrink(slots: number[], amount: number): void;
        abstract getSlotLimit(arg0: number): number;
        grow(slot: number, amount: number): Internal.ItemStack;
        abstract canInsert(arg0: number, arg1: Internal.ItemStack_): boolean;
        getStack(slot: number): Internal.ItemStack;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        shrink(slot: number, amount: number): Internal.ItemStack;
        onSlotChanged(slot: number): void;
        abstract getInventory(): owmii.powah.lib.logistics.inventory.Inventory;
        abstract canExtract(arg0: number, arg1: Internal.ItemStack_): boolean;
        get inventory(): owmii.powah.lib.logistics.inventory.Inventory
    }
    type IInventoryHolder_ = IInventoryHolder;
    abstract class ArtifactAttributeModifier {
        constructor(attribute: Internal.Attribute_, modifierId: Internal.UUID_, modifierName: string)
        abstract getAmount(): number;
        static create(attribute: Internal.Attribute_, modifierId: Internal.UUID_, modifierName: string, amount: Internal.Supplier_<number>): Internal.ArtifactAttributeModifier;
        getOperation(): Internal.AttributeModifier$Operation;
        getAttribute(): Internal.Attribute;
        get amount(): number
        get operation(): Internal.AttributeModifier$Operation
        get attribute(): Internal.Attribute
    }
    type ArtifactAttributeModifier_ = ArtifactAttributeModifier;
    class RocketItem extends Internal.VehicleItem {
        constructor(type: Internal.Supplier_<Internal.EntityType<any>>, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RocketItem_ = RocketItem;
    interface ISpeedNotifiable {
        abstract notifySpeed(arg0: number): void;
        (arg0: number): void;
    }
    type ISpeedNotifiable_ = ISpeedNotifiable;
    class DimensionPalette {
        constructor()
        encode(dimension: Internal.ResourceKey_<Internal.Level>): number;
        static receive(buffer: Internal.FriendlyByteBuf_): Internal.DimensionPalette;
        static read(tag: Internal.CompoundTag_): Internal.DimensionPalette;
        send(buffer: Internal.FriendlyByteBuf_): void;
        decode(index: number): Internal.ResourceKey<Internal.Level>;
        write(tag: Internal.CompoundTag_): void;
    }
    type DimensionPalette_ = DimensionPalette;
    class StationEditPacket extends Internal.BlockEntityConfigurationPacket<Internal.StationBlockEntity> implements Internal.ILimited {
        constructor(pos: BlockPos_)
        constructor(buffer: Internal.FriendlyByteBuf_)
        static dropSchedule(pos: BlockPos_): Internal.StationEditPacket;
        static tryDisassemble(pos: BlockPos_): Internal.StationEditPacket;
        static configure(pos: BlockPos_, assemble: boolean, name: string, doorControl: Internal.DoorControl_): Internal.StationEditPacket;
        isLimitEnabled(): boolean;
        static tryAssemble(pos: BlockPos_): Internal.StationEditPacket;
        setLimitEnabled(limitEnabled: boolean): void;
        static makeLimitEnabledPacket(pos: BlockPos_, limitEnabled: boolean): Internal.StationEditPacket;
        get limitEnabled(): boolean
        set limitEnabled(limitEnabled: boolean)
    }
    type StationEditPacket_ = StationEditPacket;
    class DaylightDetectorBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly INVERTED: Internal.BooleanProperty;
        static readonly POWER: Internal.IntegerProperty;
    }
    type DaylightDetectorBlock_ = DaylightDetectorBlock;
    class BlockFace extends net.createmod.catnip.data.Pair<BlockPos, Internal.Direction> {
        constructor(first: BlockPos_, second: Internal.Direction_)
        getPos(): BlockPos;
        getOpposite(): this;
        getConnectedPos(): BlockPos;
        getOppositeFace(): Internal.Direction;
        isEquivalent(other: Internal.BlockFace_): boolean;
        static fromNBT(compound: Internal.CompoundTag_): Internal.BlockFace;
        getFace(): Internal.Direction;
        serializeNBT(): Internal.CompoundTag;
        get pos(): BlockPos
        get opposite(): Internal.BlockFace
        get connectedPos(): BlockPos
        get oppositeFace(): Internal.Direction
        get face(): Internal.Direction
    }
    type BlockFace_ = BlockFace;
    /**
     * Invoked when registering handlers for item tooltips.
     * 
     * `text` can be a component or a list of components.
    */
    class ItemTooltipEventJS extends Internal.EventJS {
        constructor(m: Internal.Map_<Internal.Item, Internal.List<any>>)
        /**
         * Adds a dynamic tooltip handler to all items matching the ingredient.
        */
        addAdvanced(item: Internal.Ingredient_, handler: Internal.ItemTooltipEventJS$StaticTooltipHandlerFromJS_): void;
        addAdvanced(item: Internal.Ingredient_, handler: Internal.ItemTooltipEventJS$StaticTooltipHandlerFromJS_): void;
        add(item: Internal.Ingredient_, text: Internal.ArrayOrSelf_<net.minecraft.network.chat.Component>): void;
        /**
         * Is shift key pressed.
        */
        isShift(): boolean;
        addToAll(text: net.minecraft.network.chat.Component_): void;
        /**
         * Is alt key pressed.
        */
        isAlt(): boolean;
        /**
         * Is control key pressed.
        */
        isCtrl(): boolean;
        /**
         * Adds text to all items matching the ingredient.
        */
        add(item: Internal.Ingredient_, text: any): void;
        /**
         * Adds a dynamic tooltip handler to all items.
        */
        addAdvancedToAll(handler: Internal.ItemTooltipEventJS$StaticTooltipHandlerFromJS_): void;
        /**
         * Is shift key pressed.
        */
        get shift(): boolean
        /**
         * Is alt key pressed.
        */
        get alt(): boolean
        /**
         * Is control key pressed.
        */
        get ctrl(): boolean
    }
    type ItemTooltipEventJS_ = ItemTooltipEventJS;
    class KeyboardHandler implements Internal.IF3KeyStateSetter {
        constructor($$0: Internal.Minecraft_)
        handler$bmo000$emi$onChar(window: number, codePoint: number, modifiers: number, info: Internal.CallbackInfo_): void;
        handler$beo000$balm$keyPress(window: number, key: number, scanCode: number, action: number, modifiers: number, callbackInfo: Internal.CallbackInfo_): void;
        handler$zpj000$architectury$onKey(long_1: number, int_1: number, int_2: number, int_3: number, int_4: number, info: Internal.CallbackInfo_): void;
        handler$zpj000$architectury$onRawKey(handle: number, key: number, scanCode: number, action: number, modifiers: number, info: Internal.CallbackInfo_): void;
        handler$dal000$glitchcore$onKeyInput(window: number, key: number, scanCode: number, action: number, modifiers: number, ci: Internal.CallbackInfo_): void;
        handler$iaf002$sophisticatedcore$keyPress(handle: number, key: number, scanCode: number, action: number, modifiers: number, ci: Internal.CallbackInfo_): void;
        handler$zfh000$porting_lib_base$port_lib$onHandleKeyInput(window: number, key: number, scancode: number, action: number, mods: number, ci: Internal.CallbackInfo_): void;
        setup($$0: number): void;
        getClipboard(): string;
        tick(): void;
        handler$bmo001$emi$onKey(window: number, key: number, scancode: number, action: number, modifiers: number, info: Internal.CallbackInfo_): void;
        setClipboard($$0: string): void;
        handler$ecc001$kuma_api$keyPress(window: number, key: number, scanCode: number, action: number, modifiers: number, callbackInfo: Internal.CallbackInfo_): void;
        keyPress($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): void;
        setF3KeyState(value: boolean): void;
        handler$zpj000$architectury$onKeyAfter(long_1: number, int_1: number, int_2: number, int_3: number, int_4: number, info: Internal.CallbackInfo_, screen: Internal.Screen_, bls: boolean[]): void;
        set up($$0: number)
        get clipboard(): string
        set clipboard($$0: string)
        set f3KeyState(value: boolean)
        static readonly DEBUG_CRASH_TIME: 10000;
    }
    type KeyboardHandler_ = KeyboardHandler;
    class BlazeBurnerBlockEntity$FuelType extends Internal.Enum<Internal.BlazeBurnerBlockEntity$FuelType> {
        static values(): Internal.BlazeBurnerBlockEntity$FuelType[];
        static valueOf(name: string): Internal.BlazeBurnerBlockEntity$FuelType;
        static readonly NONE: Internal.BlazeBurnerBlockEntity$FuelType;
        static readonly SPECIAL: Internal.BlazeBurnerBlockEntity$FuelType;
        static readonly NORMAL: Internal.BlazeBurnerBlockEntity$FuelType;
    }
    type BlazeBurnerBlockEntity$FuelType_ = "normal" | BlazeBurnerBlockEntity$FuelType | "special" | "none";
    class AgriSoil$Builder {
        constructor()
        mods(...mods: string[]): this;
        growthModifier(growthModifier: number): this;
        variants(...variants: Internal.AgriSoilVariant_[]): this;
        defaultMods(): this;
        build(): Internal.AgriSoil;
        humidity(humidity: Internal.AgriSoilCondition$Humidity_): this;
        acidity(acidity: Internal.AgriSoilCondition$Acidity_): this;
        nutrients(nutrients: Internal.AgriSoilCondition$Nutrients_): this;
    }
    type AgriSoil$Builder_ = AgriSoil$Builder;
    class ValueSettingsBehaviour$ValueSettings extends Internal.Record {
        constructor(row: number, value: number)
        format(): Internal.MutableComponent;
        row(): number;
        value(): number;
    }
    type ValueSettingsBehaviour$ValueSettings_ = ValueSettingsBehaviour$ValueSettings;
    interface Char2ShortFunction extends it.unimi.dsi.fastutil.Function<string, number>, Internal.IntUnaryOperator {
        composeObject<T>(arg0: Internal.Object2CharFunction_<T>): Internal.Object2ShortFunction<T>;
        andThenByte(arg0: Internal.Short2ByteFunction_): Internal.Char2ByteFunction;
        apply(arg0: string): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, string>): Internal.Function<T, number>;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        containsKey(arg0: string): boolean;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeByte(arg0: Internal.Byte2CharFunction_): Internal.Byte2ShortFunction;
        defaultReturnValue(): number;
        composeInt(arg0: Internal.Int2CharFunction_): Internal.Int2ShortFunction;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        identity(): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenObject<T>(arg0: Internal.Short2ObjectFunction_<T>): Internal.Char2ObjectFunction<T>;
        composeDouble(arg0: Internal.Double2CharFunction_): Internal.Double2ShortFunction;
        andThenLong(arg0: Internal.Short2LongFunction_): Internal.Char2LongFunction;
        composeChar(arg0: Internal.Char2CharFunction_): this;
        put(arg0: string, arg1: number): number;
        composeReference<T>(arg0: Internal.Reference2CharFunction_<T>): Internal.Reference2ShortFunction<T>;
        andThenReference<T>(arg0: Internal.Short2ReferenceFunction_<T>): Internal.Char2ReferenceFunction<T>;
        andThenShort(arg0: Internal.Short2ShortFunction_): this;
        composeLong(arg0: Internal.Long2CharFunction_): Internal.Long2ShortFunction;
        /**
         * @deprecated
        */
        put(arg0: string, arg1: number): number;
        size(): number;
        remove(arg0: string): number;
        composeFloat(arg0: Internal.Float2CharFunction_): Internal.Float2ShortFunction;
        defaultReturnValue(arg0: number): void;
        andThenDouble(arg0: Internal.Short2DoubleFunction_): Internal.Char2DoubleFunction;
        clear(): void;
        abstract get(arg0: string): number;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        getOrDefault(arg0: string, arg1: number): number;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<string, T>;
        andThenFloat(arg0: Internal.Short2FloatFunction_): Internal.Char2FloatFunction;
        composeShort(arg0: Internal.Short2CharFunction_): Internal.Short2ShortFunction;
        andThenInt(arg0: Internal.Short2IntFunction_): Internal.Char2IntFunction;
        andThenChar(arg0: Internal.Short2CharFunction_): Internal.Char2CharFunction;
        (arg0: string): number;
    }
    type Char2ShortFunction_ = Char2ShortFunction;
    interface IBackpackWrapper extends Internal.IStorageWrapper {
        abstract getDisplayName(): net.minecraft.network.chat.Component;
        unregisterOnInventoryHandlerRefreshListener(): void;
        setInventorySlotChangeHandler(slotChangeHandler: Internal.Runnable_): void;
        abstract sort(): void;
        abstract refreshInventoryForInputOutput(): void;
        abstract getStorageType(): string;
        getBaseStackSizeMultiplier(): number;
        registerOnSlotsChangeListener(onSlotsChange: Internal.IntConsumer_): void;
        getSettingsHandler(): Internal.SettingsHandler;
        abstract getUpgradeHandler(): Internal.UpgradeHandler;
        getWrappedStorageStack(): Internal.ItemStack;
        onInit(): void;
        abstract refreshInventoryForUpgradeProcessing(): void;
        abstract copyDataTo(arg0: Internal.IStorageWrapper_): void;
        abstract setContentsChangeHandler(arg0: Internal.Runnable_): void;
        abstract getOpenTabId(): Internal.Optional<number>;
        removeContentsUUIDTag(): void;
        getEnergyStorage(): Internal.Optional<Internal.EnergyStorage>;
        unregisterOnSlotsChangeListener(): void;
        abstract setSlotNumbers(arg0: number, arg1: number): void;
        abstract setOpenTabId(arg0: number): void;
        abstract setPersistent(arg0: boolean): void;
        removeContentsUuid(): void;
        getNumberOfSlotRows(): number;
        abstract getContentsUuid(): Internal.Optional<Internal.UUID>;
        abstract getBackpack(): Internal.ItemStack;
        abstract getAccentColor(): number;
        abstract cloneBackpack(): Internal.ItemStack;
        abstract getSortBy(): Internal.SortBy;
        abstract getInventoryHandler(): Internal.InventoryHandler;
        abstract getMainColor(): number;
        abstract getColumnsTaken(): number;
        abstract onContentsNbtUpdated(): void;
        abstract setSortBy(arg0: Internal.SortBy_): void;
        getFluidHandler(): Internal.Optional<Internal.IStorageFluidHandler>;
        abstract getRenderInfo(): Internal.RenderInfo;
        registerOnInventoryHandlerRefreshListener(onInventoryHandlerRefresh: Internal.Runnable_): void;
        setUpgradeCachesInvalidatedHandler(handler: Internal.Runnable_): void;
        abstract setContentsUuid(arg0: Internal.UUID_): void;
        abstract getInventoryForInputOutput(): Internal.ITrackedContentsItemHandler;
        abstract getInventoryForUpgradeProcessing(): Internal.ITrackedContentsItemHandler;
        abstract fillWithLoot(arg0: Internal.Player_): void;
        abstract removeOpenTabId(): void;
        abstract setLoot(arg0: ResourceLocation_, arg1: number): void;
        abstract setColumnsTaken(arg0: number, arg1: boolean): void;
        abstract setColors(arg0: number, arg1: number): void;
        get displayName(): net.minecraft.network.chat.Component
        set inventorySlotChangeHandler(slotChangeHandler: Internal.Runnable_)
        get storageType(): string
        get baseStackSizeMultiplier(): number
        get settingsHandler(): Internal.SettingsHandler
        get upgradeHandler(): Internal.UpgradeHandler
        get wrappedStorageStack(): Internal.ItemStack
        set contentsChangeHandler(arg0: Internal.Runnable_)
        get openTabId(): Internal.Optional<number>
        get energyStorage(): Internal.Optional<Internal.EnergyStorage>
        set openTabId(arg0: number)
        set persistent(arg0: boolean)
        get numberOfSlotRows(): number
        get contentsUuid(): Internal.Optional<Internal.UUID>
        get backpack(): Internal.ItemStack
        get accentColor(): number
        get sortBy(): Internal.SortBy
        get inventoryHandler(): Internal.InventoryHandler
        get mainColor(): number
        get columnsTaken(): number
        set sortBy(arg0: Internal.SortBy_)
        get fluidHandler(): Internal.Optional<Internal.IStorageFluidHandler>
        get renderInfo(): Internal.RenderInfo
        set upgradeCachesInvalidatedHandler(handler: Internal.Runnable_)
        set contentsUuid(arg0: Internal.UUID_)
        get inventoryForInputOutput(): Internal.ITrackedContentsItemHandler
        get inventoryForUpgradeProcessing(): Internal.ITrackedContentsItemHandler
    }
    type IBackpackWrapper_ = IBackpackWrapper;
    class CubeVoxelShape extends Internal.VoxelShape implements Internal.CubeVoxelShapeAccessor {
        static port_lib$init$porting_lib_accessors_$md$fca01f$0(arg0: Internal.DiscreteVoxelShape_): Internal.CubeVoxelShape;
        static port_lib$init(discreteVoxelShape: Internal.DiscreteVoxelShape_): Internal.CubeVoxelShape;
    }
    type CubeVoxelShape_ = CubeVoxelShape;
    class Axolotl$Variant extends Internal.Enum<Internal.Axolotl$Variant> implements Internal.StringRepresentable {
        static valueOf($$0: string): Internal.Axolotl$Variant;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static byId($$0: number): Internal.Axolotl$Variant;
        getName(): string;
        static values(): Internal.Axolotl$Variant[];
        static getCommonSpawnVariant($$0: Internal.RandomSource_): Internal.Axolotl$Variant;
        static getRareSpawnVariant($$0: Internal.RandomSource_): Internal.Axolotl$Variant;
        getId(): number;
        get serializedName(): string
        get name(): string
        get id(): number
        static readonly GOLD: Internal.Axolotl$Variant;
        static readonly CYAN: Internal.Axolotl$Variant;
        static readonly BLUE: Internal.Axolotl$Variant;
        static readonly CODEC: Internal.Codec<Internal.Axolotl$Variant>;
        static readonly LUCY: Internal.Axolotl$Variant;
        static readonly WILD: Internal.Axolotl$Variant;
    }
    type Axolotl$Variant_ = "gold" | "wild" | Axolotl$Variant | "blue" | "lucy" | "cyan";
    class DecoratedPotBlockEntity extends Internal.BlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getDecorations(): Internal.DecoratedPotBlockEntity$Decorations;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        setFromItem($$0: Internal.ItemStack_): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getUpdatePacket(): Internal.Packet<any>;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getDirection(): Internal.Direction;
        get decorations(): Internal.DecoratedPotBlockEntity$Decorations
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        set fromItem($$0: Internal.ItemStack_)
        get updatePacket(): Internal.Packet<any>
        get direction(): Internal.Direction
        static readonly TAG_SHERDS: "sherds";
    }
    type DecoratedPotBlockEntity_ = DecoratedPotBlockEntity;
    class TwigletTreeFeature extends Internal.BOPTreeFeature<any> {
        constructor(codec: Internal.Codec_<any>)
    }
    type TwigletTreeFeature_ = TwigletTreeFeature;
    class Manure extends Internal.Block {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type Manure_ = Manure;
    class FluixSpadeItem extends Internal.ShovelItem implements Internal.IntrinsicEnchantItem {
        constructor(props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getIntrinsicEnchantLevel(stack: Internal.ItemStack_, enchantment: Internal.Enchantment_): number;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static getPathStates(): Internal.Map<Internal.Block, Internal.BlockState>;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get pathStates(): Internal.Map<Internal.Block, Internal.BlockState>
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type FluixSpadeItem_ = FluixSpadeItem;
    class PoweredShaftBlock extends Internal.AbstractShaftBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.KineticBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static stillValid(pState: Internal.BlockState_, pLevel: Internal.LevelReader_, pPos: BlockPos_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.KineticBlockEntity>): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.KineticBlockEntity>;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockEntityType(): Internal.BlockEntityType<Internal.KineticBlockEntity>;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.KineticBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        showCapacityWithAnnotation(): boolean;
        emi(amount: number): Internal.EmiStack;
        static getEquivalent(stateForPlacement: Internal.BlockState_): Internal.BlockState;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get blockEntityType(): Internal.BlockEntityType<Internal.KineticBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type PoweredShaftBlock_ = PoweredShaftBlock;
    interface GrindstoneMenuExtension {
        getXp(): number;
        get xp(): number
    }
    type GrindstoneMenuExtension_ = GrindstoneMenuExtension;
    interface IrisExtendedBufferBuilder {
        abstract iris$currentRenderType(): number;
        abstract iris$vertexCount(): number;
        abstract iris$injectNormalAndUV1(): boolean;
        abstract iris$incrementVertexCount(): void;
        abstract iris$resetVertexCount(): void;
        abstract iris$mode(): Internal.VertexFormat$Mode;
        abstract iris$currentLocalPosY(): number;
        abstract iris$currentLocalPosZ(): number;
        abstract iris$format(): Internal.VertexFormat;
        abstract iris$extending(): boolean;
        abstract iris$isTerrain(): boolean;
        abstract iris$currentLocalPosX(): number;
        abstract iris$currentBlock(): number;
    }
    type IrisExtendedBufferBuilder_ = IrisExtendedBufferBuilder;
    interface EntityEvents$Tracking {
        abstract onTrackingStart(arg0: Internal.Entity_, arg1: Internal.ServerPlayer_): void;
        (arg0: Internal.Entity, arg1: Internal.ServerPlayer): void;
    }
    type EntityEvents$Tracking_ = EntityEvents$Tracking;
    class NodeRotation extends Internal.Enum<Internal.NodeRotation> implements Internal.StringRepresentable {
        getRotation(): Internal.Rotation;
        updateRelative(current: Vec3i_): Vec3i;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf(name: string): Internal.NodeRotation;
        rotate(current: Internal.Direction_, handleY: boolean): Internal.Direction;
        getSerializedName(): string;
        static get(axis: Internal.Direction$Axis_, rotation: Internal.Rotation_): Internal.NodeRotation;
        getAxis(): Internal.Direction$Axis;
        static values(): Internal.NodeRotation[];
        get rotation(): Internal.Rotation
        get serializedName(): string
        get axis(): Internal.Direction$Axis
        static readonly Y_CLOCKWISE_90: Internal.NodeRotation;
        static readonly Y_CLOCKWISE_180: Internal.NodeRotation;
        static readonly X_COUNTERCLOCKWISE_90: Internal.NodeRotation;
        static readonly Z_CLOCKWISE_180: Internal.NodeRotation;
        static readonly Y_COUNTERCLOCKWISE_90: Internal.NodeRotation;
        static readonly X_CLOCKWISE_90: Internal.NodeRotation;
        static readonly X_CLOCKWISE_180: Internal.NodeRotation;
        static readonly VALUES: Internal.NodeRotation[];
        static readonly NONE: Internal.NodeRotation;
        static readonly Z_CLOCKWISE_90: Internal.NodeRotation;
        static readonly ROTATION: Internal.EnumProperty<Internal.NodeRotation>;
        static readonly Z_COUNTERCLOCKWISE_90: Internal.NodeRotation;
    }
    type NodeRotation_ = "x_clockwise_90" | "z_counterclockwise_90" | "z_clockwise_180" | "y_clockwise_180" | "x_counterclockwise_90" | "x_clockwise_180" | "y_clockwise_90" | "y_counterclockwise_90" | NodeRotation | "none" | "z_clockwise_90";
    interface ContactInformation {
        abstract get(arg0: string): Internal.Optional<string>;
        abstract asMap(): Internal.Map<string, string>;
        readonly EMPTY: Internal.ContactInformation;
    }
    type ContactInformation_ = ContactInformation;
    interface ServerLevelAccessor extends Internal.LevelAccessor {
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_): Internal.Player;
        dayTime(): number;
        abstract getShade(arg0: Internal.Direction_, arg1: boolean): number;
        getSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        isUnobstructed($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        getMaxSection(): number;
        abstract getLevelData(): Internal.LevelData;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        getSectionYFromSectionIndex($$0: number): number;
        abstract players(): Internal.List<Internal.Player>;
        abstract getBiomeManager(): Internal.BiomeManager;
        abstract getRandom(): Internal.RandomSource;
        isEmptyBlock($$0: BlockPos_): boolean;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        abstract removeBlock(arg0: BlockPos_, arg1: boolean): boolean;
        playSound($$0: Internal.Player_, $$1: BlockPos_, $$2: Internal.SoundEvent_, $$3: Internal.SoundSource_): void;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        getTimeOfDay($$0: number): number;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getHeightmapPos($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        blockUpdated($$0: BlockPos_, $$1: Internal.Block_): void;
        abstract setBlock(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: number, arg3: number): boolean;
        abstract isClientSide(): boolean;
        getEntities($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.Entity>;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_): Internal.List<T>;
        abstract getBlockTicks(): Internal.LevelTickAccess<Internal.Block>;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getPathfindingCostFromLightLevels($$0: BlockPos_): number;
        abstract dimensionType(): Internal.DimensionType;
        abstract getSkyDarken(): number;
        getMinBuildHeight(): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number): void;
        getLoadedChunk(chunkX: number, chunkZ: number): Internal.ChunkAccess;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<any>;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: boolean): Internal.Player;
        abstract destroyBlock(arg0: BlockPos_, arg1: boolean, arg2: Internal.Entity_, arg3: number): boolean;
        /**
         * @deprecated
        */
        hasChunkAt($$0: number, $$1: number): boolean;
        /**
         * @deprecated
        */
        abstract getSeaLevel(): number;
        abstract getFluidTicks(): Internal.LevelTickAccess<Internal.Fluid>;
        getSectionIndex($$0: number): number;
        getDirectSignalTo($$0: BlockPos_): number;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: number, $$2: number, $$3: number): Internal.Player;
        getMaxBuildHeight(): number;
        /**
         * @deprecated
        */
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number): void;
        getChunk($$0: number, $$1: number): Internal.ChunkAccess;
        addFreshEntity($$0: Internal.Entity_): boolean;
        hasSignal($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        getHeight(): number;
        getChunk($$0: BlockPos_): Internal.ChunkAccess;
        abstract isFluidAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.FluidState>): boolean;
        abstract getWorldBorder(): Internal.WorldBorder;
        getMaxLocalRawBrightness($$0: BlockPos_): number;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        /**
         * @deprecated
        */
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        /**
         * @deprecated
        */
        hasChunkAt($$0: BlockPos_): boolean;
        getBiome($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue($$0: BlockPos_): number;
        scheduleTick($$0: BlockPos_, $$1: Internal.Block_, $$2: number, $$3: Internal.TickPriority_): void;
        hasNearbyAlivePlayer($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        abstract gameEvent(arg0: Internal.GameEvent_, arg1: Vec3d_, arg2: Internal.GameEvent$Context_): void;
        getEntitiesOfClass<T extends Internal.Entity>($$0: T, $$1: Internal.AABB_, $$2: Internal.Predicate_<T>): Internal.List<T>;
        getNearestPlayer($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number): Internal.Player;
        neighborShapeChanged($$0: Internal.Direction_, $$1: Internal.BlockState_, $$2: BlockPos_, $$3: BlockPos_, $$4: number, $$5: number): void;
        getControlInputSignal($$0: BlockPos_, $$1: Internal.Direction_, $$2: boolean): number;
        getBlockTint($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        getMinSection(): number;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3d_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3d>;
        abstract getBlockState(arg0: BlockPos_): Internal.BlockState;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        abstract playSound(arg0: Internal.Player_, arg1: BlockPos_, arg2: Internal.SoundEvent_, arg3: Internal.SoundSource_, arg4: number, arg5: number): void;
        getNearestPlayer($$0: Internal.Entity_, $$1: number): Internal.Player;
        hasNeighborSignal($$0: BlockPos_): boolean;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        abstract addParticle(arg0: Internal.ParticleOptions_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number): void;
        abstract getCurrentDifficultyAt(arg0: BlockPos_): Internal.DifficultyInstance;
        getDifficulty(): Internal.Difficulty;
        canSeeSky($$0: BlockPos_): boolean;
        abstract enabledFeatures(): Internal.FeatureFlagSet;
        getMoonPhase(): number;
        isUnobstructed($$0: Internal.Entity_): boolean;
        getNearestEntity<T extends Internal.LivingEntity>($$0: Internal.List_<T>, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number): T;
        abstract getUncachedNoiseBiome(arg0: number, arg1: number, arg2: number): Internal.Holder<Internal.Biome>;
        addFreshEntityWithPassengers($$0: Internal.Entity_): void;
        abstract getEntities(arg0: Internal.Entity_, arg1: Internal.AABB_, arg2: Internal.Predicate_<Internal.Entity>): Internal.List<Internal.Entity>;
        getPlayerByUUID($$0: Internal.UUID_): Internal.Player;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        holderLookup<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup<T>;
        abstract getHeight(arg0: Internal.Heightmap$Types_, arg1: number, arg2: number): number;
        getSectionsCount(): number;
        abstract isStateAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.BlockState>): boolean;
        getNearbyPlayers($$0: Internal.TargetingConditions_, $$1: Internal.LivingEntity_, $$2: Internal.AABB_): Internal.List<Internal.Player>;
        getSectionIndexFromSectionY($$0: number): number;
        abstract getServer(): Internal.MinecraftServer;
        abstract levelEvent(arg0: Internal.Player_, arg1: number, arg2: BlockPos_, arg3: number): void;
        setBlock($$0: BlockPos_, $$1: Internal.BlockState_, $$2: number): boolean;
        getChunk($$0: number, $$1: number, $$2: Internal.ChunkStatus_): Internal.ChunkAccess;
        noCollision($$0: Internal.Entity_): boolean;
        abstract getLevel(): Internal.ServerLevel;
        abstract getEntities<T extends Internal.Entity>(arg0: Internal.EntityTypeTest_<Internal.Entity, T>, arg1: Internal.AABB_, arg2: Internal.Predicate_<T>): Internal.List<T>;
        getBestNeighborSignal($$0: BlockPos_): number;
        hasChunk($$0: number, $$1: number): boolean;
        getNearbyEntities<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: Internal.AABB_): Internal.List<T>;
        getBlockEntityRenderData(pos: BlockPos_): any;
        getMoonBrightness(): number;
        noCollision($$0: Internal.AABB_): boolean;
        isWaterAt($$0: BlockPos_): boolean;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        getEntityCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        abstract getLightEngine(): Internal.LevelLightEngine;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        abstract getBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        getNoiseBiome($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        gameEvent($$0: Internal.GameEvent_, $$1: BlockPos_, $$2: Internal.GameEvent$Context_): void;
        noCollision($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        scheduleTick($$0: BlockPos_, $$1: Internal.Fluid_, $$2: number, $$3: Internal.TickPriority_): void;
        isOutsideBuildHeight($$0: number): boolean;
        getNearestPlayer($$0: number, $$1: number, $$2: number, $$3: number, $$4: Internal.Predicate_<Internal.Entity>): Internal.Player;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: Vec3d_): void;
        abstract getFluidState(arg0: BlockPos_): Internal.FluidState;
        abstract getChunkSource(): Internal.ChunkSource;
        abstract getChunk(arg0: number, arg1: number, arg2: Internal.ChunkStatus_, arg3: boolean): Internal.ChunkAccess;
        abstract registryAccess(): Internal.RegistryAccess;
        findSupportingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Optional<BlockPos>;
        levelEvent($$0: number, $$1: BlockPos_, $$2: number): void;
        abstract nextSubTickCount(): number;
        gameEvent($$0: Internal.Entity_, $$1: Internal.GameEvent_, $$2: BlockPos_): void;
        getChunkForCollisions($$0: number, $$1: number): Internal.BlockGetter;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        getNearestEntity<T extends Internal.LivingEntity>($$0: T, $$1: Internal.TargetingConditions_, $$2: Internal.LivingEntity_, $$3: number, $$4: number, $$5: number, $$6: Internal.AABB_): T;
        isAreaLoaded(center: BlockPos_, range: number): boolean;
        traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get maxSection(): number
        get levelData(): Internal.LevelData
        get biomeManager(): Internal.BiomeManager
        get random(): Internal.RandomSource
        get clientSide(): boolean
        get blockTicks(): Internal.LevelTickAccess<Internal.Block>
        get skyDarken(): number
        get minBuildHeight(): number
        /**
         * @deprecated
        */
        get seaLevel(): number
        get fluidTicks(): Internal.LevelTickAccess<Internal.Fluid>
        get maxBuildHeight(): number
        get height(): number
        get worldBorder(): Internal.WorldBorder
        get minSection(): number
        get difficulty(): Internal.Difficulty
        get moonPhase(): number
        get sectionsCount(): number
        get server(): Internal.MinecraftServer
        get level(): Internal.ServerLevel
        get moonBrightness(): number
        get lightEngine(): Internal.LevelLightEngine
        get chunkSource(): Internal.ChunkSource
        get maxLightLevel(): number
    }
    type ServerLevelAccessor_ = ServerLevelAccessor;
    class HoeItem extends Internal.DiggerItem implements net.fabricmc.fabric.mixin.content.registry.HoeItemAccessor, Internal.HoeItemAccessor, Internal.VanillaToolActionItem {
        constructor($$0: Internal.Tier_, $$1: number, $$2: number, $$3: Internal.Item$Properties_)
        static onlyIfAirAbove($$0: Internal.UseOnContext_): boolean;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        static getTillingActions$emi_$md$fca01f$0(): Internal.Map<any, any>;
        static changeIntoState($$0: Internal.BlockState_): Internal.Consumer<Internal.UseOnContext>;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        static getTillingActions(): Internal.Map<Internal.Block, com.mojang.datafixers.util.Pair<Internal.Predicate<Internal.UseOnContext>, Internal.Consumer<Internal.UseOnContext>>>;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static changeIntoStateAndDropItem($$0: Internal.BlockState_, $$1: Internal.ItemLike_): Internal.Consumer<Internal.UseOnContext>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        port_lib$canPerformAction(stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        static "getTillingActions$fabric-content-registries-v0_$md$fca01f$1"(): Internal.Map<any, any>;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get tillingActions$emi_$md$fca01f$0(): Internal.Map<any, any>
        set attackSpeed(attackSpeed: number)
        get tillingActions(): Internal.Map<Internal.Block, com.mojang.datafixers.util.Pair<Internal.Predicate<Internal.UseOnContext>, Internal.Consumer<Internal.UseOnContext>>>
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get "tillingActions$fabric-content-registries-v0_$md$fca01f$1"(): Internal.Map<any, any>
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static TILLABLES: {[key: Internal.RootedDirtBlock]: com.mojang.datafixers.util.Pair<any, any>, [key: Internal.RichSoilBlock]: com.mojang.datafixers.util.Pair<any, any>, [key: Internal.GrassBlock]: com.mojang.datafixers.util.Pair<any, any>, [key: Internal.Block]: com.mojang.datafixers.util.Pair<any, any>, [key: Internal.Block]: com.mojang.datafixers.util.Pair<any, any>, [key: Internal.DirtPathBlock]: com.mojang.datafixers.util.Pair<any, any>, [key: Internal.OriginGrassBlock]: com.mojang.datafixers.util.Pair<any, any>};
    }
    type HoeItem_ = HoeItem;
    class ServerboundSetCommandMinecartPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: string, $$2: boolean)
        handle(arg0: Internal.PacketListener_): void;
        getCommand(): string;
        isTrackOutput(): boolean;
        getCommandBlock($$0: Internal.Level_): Internal.BaseCommandBlock;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        isSkippable(): boolean;
        get command(): string
        get trackOutput(): boolean
        get skippable(): boolean
    }
    type ServerboundSetCommandMinecartPacket_ = ServerboundSetCommandMinecartPacket;
    class BigDripleafFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static isAir(p_65811_: Internal.LevelSimulatedReader_, p_65812_: BlockPos_): boolean;
        static copyWaterloggedFrom(p_182454_: Internal.LevelReader_, p_182455_: BlockPos_, p_182456_: Internal.BlockState_): Internal.BlockState;
    }
    type BigDripleafFeature_ = BigDripleafFeature;
    interface DoubleBinaryOperator {
        abstract applyAsDouble(arg0: number, arg1: number): number;
        (arg0: number, arg1: number): number;
    }
    type DoubleBinaryOperator_ = DoubleBinaryOperator;
    class TagManager implements Internal.PreparableReloadListener, Internal.IdentifiableResourceReloadListener {
        constructor($$0: Internal.RegistryAccess_)
        getName(): string;
        getResult(): Internal.List<Internal.TagManager$LoadResult<any>>;
        getFabricDependencies(): Internal.Collection<any>;
        getFabricId(): ResourceLocation;
        static getTagDir($$0: Internal.ResourceKey_<Internal.Registry<any>>): string;
        reload($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        get name(): string
        get result(): Internal.List<Internal.TagManager$LoadResult<any>>
        get fabricDependencies(): Internal.Collection<any>
        get fabricId(): ResourceLocation
    }
    type TagManager_ = TagManager;
    class EquipmentContext {
        constructor(entity: Internal.LivingEntity_)
        hasModifiableArmor(): boolean;
        getToolInSlot(slotType: Internal.EquipmentSlot_): Internal.IToolStackView;
        getEntity(): Internal.LivingEntity;
        getTinkerData(): io.github.fabricators_of_create.porting_lib.util.LazyOptional<Internal.TinkerDataCapability$Holder>;
        get entity(): Internal.LivingEntity
        get tinkerData(): io.github.fabricators_of_create.porting_lib.util.LazyOptional<Internal.TinkerDataCapability$Holder>
    }
    type EquipmentContext_ = EquipmentContext;
    class MatrixIota extends Internal.Iota {
        constructor(matrix: Internal.DoubleMatrix_)
        getMatrix(): Internal.DoubleMatrix;
        get matrix(): Internal.DoubleMatrix
        static TYPE: Internal.MatrixIota$1;
    }
    type MatrixIota_ = MatrixIota;
    interface MouseEnter {
        abstract onMouseEnter(): void;
        newStream(): Internal.EventStream<Internal.MouseEnter>;
        (): void;
    }
    type MouseEnter_ = MouseEnter;
    interface CaveVines {
        emission($$0: number): Internal.ToIntFunction<Internal.BlockState>;
        hasGlowBerries($$0: Internal.BlockState_): boolean;
        use($$0: Internal.Entity_, $$1: Internal.BlockState_, $$2: Internal.Level_, $$3: BlockPos_): Internal.InteractionResult;
        readonly SHAPE: Internal.VoxelShapeSimpleCube;
        readonly BERRIES: Internal.BooleanProperty;
    }
    type CaveVines_ = CaveVines;
    class SingletonItemAttribute$Type implements Internal.ItemAttributeType {
        constructor(singletonFunc: Internal.Function_<Internal.SingletonItemAttribute$Type, any>)
        getAllAttributes(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemAttribute>;
        createAttribute(): Internal.ItemAttribute;
    }
    type SingletonItemAttribute$Type_ = SingletonItemAttribute$Type;
    interface Boolean2DoubleFunction extends it.unimi.dsi.fastutil.Function<boolean, number> {
        andThenShort(arg0: Internal.Double2ShortFunction_): Internal.Boolean2ShortFunction;
        /**
         * @deprecated
        */
        put(arg0: boolean, arg1: number): number;
        andThenDouble(arg0: Internal.Double2DoubleFunction_): this;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        composeByte(arg0: Internal.Byte2BooleanFunction_): Internal.Byte2DoubleFunction;
        andThenByte(arg0: Internal.Double2ByteFunction_): Internal.Boolean2ByteFunction;
        composeObject<T>(arg0: Internal.Object2BooleanFunction_<T>): Internal.Object2DoubleFunction<T>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeLong(arg0: Internal.Long2BooleanFunction_): Internal.Long2DoubleFunction;
        remove(arg0: boolean): number;
        andThenLong(arg0: Internal.Double2LongFunction_): Internal.Boolean2LongFunction;
        composeChar(arg0: Internal.Char2BooleanFunction_): Internal.Char2DoubleFunction;
        andThenObject<T>(arg0: Internal.Double2ObjectFunction_<T>): Internal.Boolean2ObjectFunction<T>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeShort(arg0: Internal.Short2BooleanFunction_): Internal.Short2DoubleFunction;
        defaultReturnValue(arg0: number): void;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        abstract get(arg0: boolean): number;
        composeReference<T>(arg0: Internal.Reference2BooleanFunction_<T>): Internal.Reference2DoubleFunction<T>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<boolean, T>;
        andThenReference<T>(arg0: Internal.Double2ReferenceFunction_<T>): Internal.Boolean2ReferenceFunction<T>;
        defaultReturnValue(): number;
        containsKey(arg0: boolean): boolean;
        andThenInt(arg0: Internal.Double2IntFunction_): Internal.Boolean2IntFunction;
        getOrDefault(arg0: boolean, arg1: number): number;
        size(): number;
        andThenFloat(arg0: Internal.Double2FloatFunction_): Internal.Boolean2FloatFunction;
        composeDouble(arg0: Internal.Double2BooleanFunction_): Internal.Double2DoubleFunction;
        composeInt(arg0: Internal.Int2BooleanFunction_): Internal.Int2DoubleFunction;
        put(arg0: boolean, arg1: number): number;
        clear(): void;
        apply(arg0: boolean): number;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, boolean>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        andThenChar(arg0: Internal.Double2CharFunction_): Internal.Boolean2CharFunction;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        composeFloat(arg0: Internal.Float2BooleanFunction_): Internal.Float2DoubleFunction;
        (arg0: boolean): number;
    }
    type Boolean2DoubleFunction_ = Boolean2DoubleFunction;
    class JsonDecorationType implements Internal.MapDecorationType<Internal.CustomMapDecoration, Internal.SimpleMapBlockMarker> {
        constructor(target: Internal.Optional_<Internal.RuleTest>)
        constructor(target: Internal.Optional_<Internal.RuleTest>, name: Internal.Optional_<string>, rotation: number, mapColor: number, structure: Internal.Optional_<Internal.HolderSet<Internal.Structure>>, enabled: boolean)
        constructor(target: Internal.Optional_<Internal.RuleTest>, name: Internal.Optional_<string>, rotation: number, mapColor: number, enabled: boolean)
        isFromWorld(): boolean;
        getId(): ResourceLocation;
        getName(): Internal.Optional<string>;
        getAssociatedStructure(): Internal.Optional<Internal.HolderSet<Internal.Structure>>;
        getRotation(): number;
        loadMarkerFromNBT(compound: Internal.CompoundTag_): Internal.SimpleMapBlockMarker;
        createEmptyMarker(): Internal.MapBlockMarker<any>;
        getDefaultMapColor(): number;
        getCustomFactoryID(): ResourceLocation;
        loadDecorationFromBuffer(buffer: Internal.FriendlyByteBuf_): Internal.CustomMapDecoration;
        getTarget(): Internal.Optional<Internal.RuleTest>;
        getWorldMarkerFromWorld(arg0: Internal.BlockGetter_, arg1: BlockPos_): Internal.MapBlockMarker<any>;
        get fromWorld(): boolean
        get id(): ResourceLocation
        get name(): Internal.Optional<string>
        get associatedStructure(): Internal.Optional<Internal.HolderSet<Internal.Structure>>
        get rotation(): number
        get defaultMapColor(): number
        get customFactoryID(): ResourceLocation
        get target(): Internal.Optional<Internal.RuleTest>
        static readonly NETWORK_CODEC: Internal.Codec<Internal.JsonDecorationType>;
        static readonly CODEC: Internal.Codec<Internal.JsonDecorationType>;
    }
    type JsonDecorationType_ = Special.MapMarkers | JsonDecorationType;
    class PartItem <T extends Internal.IPart> extends Internal.AEBaseItem implements Internal.IPartItem<T> {
        constructor(properties: Internal.Item$Properties_, partClass: T, factory: Internal.Function_<Internal.IPartItem<T>, T>)
        static getId(item: Internal.IPartItem_<any>): ResourceLocation;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getPartClass(): T;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createPart(): T;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        static byId(id: ResourceLocation_): Internal.IPartItem<any>;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static byNetworkId(id: number): Internal.IPartItem<any>;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        static getNetworkId(item: Internal.IPartItem_<any>): number;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get partClass(): T
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PartItem_<T extends Internal.IPart> = PartItem<T>;
    class ThermalCalciteVentBlock extends Internal.ThermalCalciteBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type ThermalCalciteVentBlock_ = ThermalCalciteVentBlock;
    class AnyOfCondition$Builder extends Internal.CompositeLootItemCondition$Builder {
        constructor(...$$0: Internal.LootItemCondition$Builder_[])
        and($$0: Internal.LootItemCondition$Builder_): Internal.AllOfCondition$Builder;
        invert(): Internal.LootItemCondition$Builder;
    }
    type AnyOfCondition$Builder_ = AnyOfCondition$Builder;
    class ToolboxBlock extends Internal.HorizontalDirectionalBlock implements Internal.SimpleWaterloggedBlock, Internal.IBE<Internal.ToolboxBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_, color: Internal.DyeColor_)
        getBlockEntityType(): Internal.BlockEntityType<Internal.ToolboxBlockEntity>;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getBlockEntityClass(): typeof Internal.ToolboxBlockEntity;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ToolboxBlockEntity>;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getColor(): Internal.DyeColor;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ToolboxBlockEntity>): void;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ToolboxBlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ToolboxBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        emi(): Internal.EmiStack;
        get blockEntityType(): Internal.BlockEntityType<Internal.ToolboxBlockEntity>
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityClass(): typeof Internal.ToolboxBlockEntity
        set lightEmission(v: number)
        get mod(): string
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
    }
    type ToolboxBlock_ = ToolboxBlock;
    class CastingTableBlock extends Internal.AbstractCastingBlock {
        constructor(builder: Internal.BlockBehaviour$Properties_, requireCast: boolean)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(pLevel: Internal.Level_, pState: Internal.BlockState_, check: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type CastingTableBlock_ = CastingTableBlock;
    interface WorldRendererAccessor {
        abstract getFrustum(): Internal.Frustum;
        get frustum(): Internal.Frustum
        (): Internal.Frustum_;
    }
    type WorldRendererAccessor_ = WorldRendererAccessor;
    class ModuleDescriptor$Modifier extends Internal.Enum<Internal.ModuleDescriptor$Modifier> {
        static valueOf(arg0: string): Internal.ModuleDescriptor$Modifier;
        static values(): Internal.ModuleDescriptor$Modifier[];
        static readonly AUTOMATIC: Internal.ModuleDescriptor$Modifier;
        static readonly MANDATED: Internal.ModuleDescriptor$Modifier;
        static readonly OPEN: Internal.ModuleDescriptor$Modifier;
        static readonly SYNTHETIC: Internal.ModuleDescriptor$Modifier;
    }
    type ModuleDescriptor$Modifier_ = ModuleDescriptor$Modifier | "mandated" | "open" | "synthetic" | "automatic";
    interface IEntityToolSwapUpgrade {
        abstract onEntityInteract(arg0: Internal.Level_, arg1: Internal.Entity_, arg2: Internal.Player_): boolean;
        canProcessEntityInteract(): boolean;
        (arg0: Internal.Level, arg1: Internal.Entity, arg2: Internal.Player): boolean;
    }
    type IEntityToolSwapUpgrade_ = IEntityToolSwapUpgrade;
    class ShapelessRecipeSchema$ShapelessRecipeJS extends Internal.RecipeJS {
        constructor()
        getMod(): string;
        get mod(): string
    }
    type ShapelessRecipeSchema$ShapelessRecipeJS_ = ShapelessRecipeSchema$ShapelessRecipeJS;
    interface IPartModel {
        getModels(): Internal.List<ResourceLocation>;
        requireCableConnection(): boolean;
        get models(): Internal.List<ResourceLocation>
    }
    type IPartModel_ = IPartModel;
    class FactoryPanelBehaviour extends Internal.FilteringBehaviour implements Internal.MenuProvider {
        constructor(be: Internal.FactoryPanelBlockEntity_, slot: Internal.FactoryPanelBlock$PanelSlot_)
        getDisplayName(): net.minecraft.network.chat.Component;
        getLevelInStorage(): number;
        disable(): void;
        panelBE(): Internal.FactoryPanelBlockEntity;
        static getTypeForSlot(slot: Internal.FactoryPanelBlock$PanelSlot_): Internal.BehaviourType<any>;
        setNetwork(network: Internal.UUID_): void;
        static linkAt(world: Internal.BlockAndTintGetter_, connection: Internal.FactoryPanelConnection_): Internal.FactoryPanelSupportBehaviour;
        getUnloadedLinks(): number;
        addConnection(fromPos: Internal.FactoryPanelPosition_): void;
        getFrogAddress(): string;
        createMenu(containerId: number, playerInventory: Internal.Inventory_, player: Internal.Player_): Internal.AbstractContainerMenu;
        getPromised(): number;
        mayInteract(player: Internal.Player_): boolean;
        shouldCloseCurrentScreen(): boolean;
        resetTimerSlightly(): void;
        resetTimer(): void;
        checkForRedstoneInput(): void;
        getIngredientStatusColor(): number;
        isMissingAddress(): boolean;
        onlyVisibleWithWrench(): boolean;
        static linkAt(world: Internal.BlockAndTintGetter_, pos: Internal.FactoryPanelPosition_): Internal.FactoryPanelSupportBehaviour;
        disconnectAllLinks(): void;
        enable(): void;
        moveTo(newPos: Internal.FactoryPanelPosition_, player: Internal.ServerPlayer_): void;
        playFeedbackSound(origin: Internal.BlockEntityBehaviour_): void;
        displayScreen(player: Internal.Player_): void;
        static at(world: Internal.BlockAndTintGetter_, pos: Internal.FactoryPanelPosition_): Internal.FactoryPanelBehaviour;
        disconnectAll(): void;
        getPanelPosition(): Internal.FactoryPanelPosition;
        newSettingHovered(valueSetting: Internal.ValueSettingsBehaviour$ValueSettings_): void;
        static at(world: Internal.BlockAndTintGetter_, connection: Internal.FactoryPanelConnection_): Internal.FactoryPanelBehaviour;
        get displayName(): net.minecraft.network.chat.Component
        get levelInStorage(): number
        set network(network: Internal.UUID_)
        get unloadedLinks(): number
        get frogAddress(): string
        get promised(): number
        get ingredientStatusColor(): number
        get missingAddress(): boolean
        get panelPosition(): Internal.FactoryPanelPosition
        promisedSatisfied: boolean;
        targetedBy: Internal.Map<Internal.FactoryPanelPosition, Internal.FactoryPanelConnection>;
        redstonePowered: boolean;
        targeting: Internal.Set<Internal.FactoryPanelPosition>;
        bulb: Internal.LerpedFloat;
        targetedByLinks: Internal.Map<BlockPos, Internal.FactoryPanelConnection>;
        activeCraftingArrangement: Internal.List<Internal.ItemStack>;
        promiseClearingInterval: number;
        static readonly TOP_RIGHT: Internal.BehaviourType<Internal.FactoryPanelBehaviour>;
        forceClearPromises: boolean;
        waitingForNetwork: boolean;
        recipeOutput: number;
        slot: Internal.FactoryPanelBlock$PanelSlot;
        recipeAddress: string;
        restockerPromises: Internal.RequestPromiseQueue;
        static readonly BOTTOM_RIGHT: Internal.BehaviourType<Internal.FactoryPanelBehaviour>;
        network: Internal.UUID;
        static readonly TOP_LEFT: Internal.BehaviourType<Internal.FactoryPanelBehaviour>;
        static readonly BOTTOM_LEFT: Internal.BehaviourType<Internal.FactoryPanelBehaviour>;
        active: boolean;
        satisfied: boolean;
    }
    type FactoryPanelBehaviour_ = FactoryPanelBehaviour;
    class OrangeMapleLeafPileFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type OrangeMapleLeafPileFeature_ = OrangeMapleLeafPileFeature;
    interface TeamMessage {
        abstract date(): number;
        abstract text(): net.minecraft.network.chat.Component;
        abstract sender(): Internal.UUID;
    }
    type TeamMessage_ = TeamMessage;
    class ModifierSalvage$Serializer extends Internal.LoggingRecipeSerializer<Internal.ModifierSalvage> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.ModifierSalvage;
    }
    type ModifierSalvage$Serializer_ = ModifierSalvage$Serializer;
    interface ModelManagerAccessor {
        abstract getBakedRegistry(): Internal.Map<ResourceLocation, Internal.BakedModel>;
        get bakedRegistry(): Internal.Map<ResourceLocation, Internal.BakedModel>
        (): Internal.Map_<ResourceLocation, Internal.BakedModel>;
    }
    type ModelManagerAccessor_ = ModelManagerAccessor;
    abstract class AxisCycle extends Internal.Enum<Internal.AxisCycle> {
        static values(): Internal.AxisCycle[];
        abstract cycle(arg0: number, arg1: number, arg2: number, arg3: Internal.Direction$Axis_): number;
        abstract cycle(arg0: number, arg1: number, arg2: number, arg3: Internal.Direction$Axis_): number;
        abstract inverse(): this;
        static valueOf($$0: string): Internal.AxisCycle;
        static between($$0: Internal.Direction$Axis_, $$1: Internal.Direction$Axis_): Internal.AxisCycle;
        abstract cycle(arg0: Internal.Direction$Axis_): Internal.Direction$Axis;
        static readonly AXIS_VALUES: Internal.Direction$Axis[];
        static readonly NONE: Internal.AxisCycle;
        static readonly VALUES: Internal.AxisCycle[];
        static readonly FORWARD: Internal.AxisCycle;
        static readonly BACKWARD: Internal.AxisCycle;
    }
    type AxisCycle_ = "backward" | AxisCycle | "forward" | "none";
    class ProcessingOutput {
        constructor(stack: Internal.ItemStack_, chance: number)
        constructor(item: net.createmod.catnip.data.Pair_<ResourceLocation, number>, chance: number)
        write(buf: Internal.FriendlyByteBuf_): void;
        getStack(): Internal.ItemStack;
        serialize(): Internal.JsonElement;
        getChance(): number;
        static deserialize(je: Internal.JsonElement_): Internal.ProcessingOutput;
        static read(buf: Internal.FriendlyByteBuf_): Internal.ProcessingOutput;
        rollOutput(): Internal.ItemStack;
        get stack(): Internal.ItemStack
        get chance(): number
        static readonly EMPTY: Internal.ProcessingOutput;
    }
    type ProcessingOutput_ = ProcessingOutput;
    abstract class AbstractChestBlock <E extends Internal.BlockEntity> extends Internal.BaseEntityBlock {
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        abstract combine(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: boolean): Internal.DoubleBlockCombiner$NeighborCombineResult<Internal.ChestBlockEntity>;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type AbstractChestBlock_<E extends Internal.BlockEntity> = AbstractChestBlock<E>;
    abstract class BasinOperatingBlockEntity extends Internal.KineticBlockEntity {
        constructor(typeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        startProcessingBasin(): void;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        continueWithPreviousRecipe(): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        basinRemoved: boolean;
        basinChecker: Internal.DeferralBehaviour;
    }
    type BasinOperatingBlockEntity_ = BasinOperatingBlockEntity;
    interface RenderTypeAccessor {
        abstract shouldSortOnUpload(): boolean;
        (): boolean;
    }
    type RenderTypeAccessor_ = RenderTypeAccessor;
    class Suppliers$NonSerializableMemoizingSupplier <T> implements com.google.common.base.Supplier<T> {
        get(): T;
    }
    type Suppliers$NonSerializableMemoizingSupplier_<T> = Suppliers$NonSerializableMemoizingSupplier<T>;
    class Biome$ClimateSettings extends Internal.Record {
        constructor($$0: boolean, $$1: number, $$2: Internal.Biome$TemperatureModifier_, $$3: number)
        downfall(): number;
        temperatureModifier(): Internal.Biome$TemperatureModifier;
        temperature(): number;
        hasPrecipitation(): boolean;
        temperatureModifier: Internal.Biome$TemperatureModifier;
        hasPrecipitation: boolean;
        temperature: number;
        downfall: number;
        static readonly CODEC: Internal.MapCodec<Internal.Biome$ClimateSettings>;
    }
    type Biome$ClimateSettings_ = Biome$ClimateSettings;
    class ItemDragonFlute extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemDragonFlute_ = ItemDragonFlute;
    interface AbstractTextureExtensions {
        setBlurMipmap(blur: boolean, mipmap: boolean): void;
        restoreLastBlurMipmap(): void;
    }
    type AbstractTextureExtensions_ = AbstractTextureExtensions;
    interface AgriRegistrable {
        abstract getId(): string;
        get id(): string
        (): string;
    }
    type AgriRegistrable_ = AgriRegistrable;
    class SoulSpeedEnchantment extends Internal.Enchantment {
        constructor($$0: Internal.Enchantment$Rarity_, ...$$1: Internal.EquipmentSlot_[])
    }
    type SoulSpeedEnchantment_ = SoulSpeedEnchantment;
    class BaseLangProvider extends Internal.FabricLanguageProvider {
        add(key: string, value: string): void;
        static saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
    }
    type BaseLangProvider_ = BaseLangProvider;
    interface SpriteContentsAnimationAccessor {
        abstract getFrames(): Internal.List<Internal.SpriteContents$FrameInfo>;
        get frames(): Internal.List<Internal.SpriteContents$FrameInfo>
        (): Internal.List_<Internal.SpriteContents$FrameInfo>;
    }
    type SpriteContentsAnimationAccessor_ = SpriteContentsAnimationAccessor;
    class VertexSorters$SortByDistance extends Internal.VertexSorters$AbstractVertexSorter {
        static byDistance(x: number, y: number, z: number): Internal.VertexSorting;
        static byDistance($$0: Internal.VertexSorting$DistanceFunction_): Internal.VertexSorting;
        static byDistance($$0: Vec3f_): Internal.VertexSorting;
    }
    type VertexSorters$SortByDistance_ = VertexSorters$SortByDistance;
    abstract class SettingsHandler {
        getNbt(): Internal.CompoundTag;
        getCategoriesThatImplement<T>(categoryClass: T): Internal.List<T>;
        abstract getGlobalSettingsCategoryName(): string;
        getSettingsCategories(): Internal.Map<string, Internal.ISettingsCategory<any>>;
        abstract instantiateGlobalSettingsCategory(arg0: Internal.CompoundTag_, arg1: Internal.Consumer_<Internal.CompoundTag>): Internal.ISettingsCategory<any>;
        reloadFrom(contentsNbt: Internal.CompoundTag_): void;
        getGlobalSettingsCategory(): Internal.MainSettingsCategory<any>;
        getTypeCategory<T extends Internal.ISettingsCategory<any>>(categoryClazz: T): T;
        get nbt(): Internal.CompoundTag
        get globalSettingsCategoryName(): string
        get settingsCategories(): Internal.Map<string, Internal.ISettingsCategory<any>>
        get globalSettingsCategory(): Internal.MainSettingsCategory<any>
    }
    type SettingsHandler_ = SettingsHandler;
    interface Spliterator$OfLong extends Internal.Spliterator$OfPrimitive<number, Internal.LongConsumer, Internal.Spliterator$OfLong> {
        forEachRemaining(arg0: any): void;
        trySplit(): Internal.Spliterator$OfPrimitive<any, any, any>;
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        getExactSizeIfKnown(): number;
        getComparator(): Internal.Comparator<number>;
        hasCharacteristics(arg0: number): boolean;
        abstract tryAdvance(arg0: Internal.LongConsumer_): boolean;
        tryAdvance(arg0: any): boolean;
        abstract characteristics(): number;
        abstract estimateSize(): number;
        forEachRemaining(arg0: Internal.LongConsumer_): void;
        tryAdvance(arg0: Internal.Consumer_<number>): boolean;
        get exactSizeIfKnown(): number
        get comparator(): Internal.Comparator<number>
    }
    type Spliterator$OfLong_ = Spliterator$OfLong;
    interface AccessorAbstractContainerScreen {
        abstract getTopPos(): number;
        abstract getLeftPos(): number;
        get topPos(): number
        get leftPos(): number
    }
    type AccessorAbstractContainerScreen_ = AccessorAbstractContainerScreen;
    class ZoneOffsetTransitionRule implements Internal.Serializable {
        getLocalTime(): Internal.LocalTime;
        getMonth(): Internal.Month;
        getOffsetBefore(): Internal.ZoneOffset;
        static of(arg0: Internal.Month_, arg1: number, arg2: Internal.DayOfWeek_, arg3: Internal.LocalTime_, arg4: boolean, arg5: Internal.ZoneOffsetTransitionRule$TimeDefinition_, arg6: Internal.ZoneOffset_, arg7: Internal.ZoneOffset_, arg8: Internal.ZoneOffset_): Internal.ZoneOffsetTransitionRule;
        getOffsetAfter(): Internal.ZoneOffset;
        isMidnightEndOfDay(): boolean;
        getDayOfWeek(): Internal.DayOfWeek;
        getDayOfMonthIndicator(): number;
        getTimeDefinition(): Internal.ZoneOffsetTransitionRule$TimeDefinition;
        getStandardOffset(): Internal.ZoneOffset;
        createTransition(arg0: number): Internal.ZoneOffsetTransition;
        get localTime(): Internal.LocalTime
        get month(): Internal.Month
        get offsetBefore(): Internal.ZoneOffset
        get offsetAfter(): Internal.ZoneOffset
        get midnightEndOfDay(): boolean
        get dayOfWeek(): Internal.DayOfWeek
        get dayOfMonthIndicator(): number
        get timeDefinition(): Internal.ZoneOffsetTransitionRule$TimeDefinition
        get standardOffset(): Internal.ZoneOffset
    }
    type ZoneOffsetTransitionRule_ = ZoneOffsetTransitionRule;
    class OreVeinAtlasItem extends Internal.Item implements Internal.PlatformMenuProvider {
        constructor(p_41383_: Internal.Item$Properties_)
        getDisplayName(): net.minecraft.network.chat.Component;
        menuClicked2(is: Internal.ItemStack_, opt: Internal.OreVeinAtlasClickPacket2$Option_, id: number): void;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        createMenu(pContainerId: number, pPlayerInventory: Internal.Inventory_, pPlayer: Internal.Player_): Internal.AbstractContainerMenu;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        shouldCloseCurrentScreen(): boolean;
        menuClicked(is: Internal.ItemStack_, opt: Internal.OreVeinAtlasClickPacket$Option_, id: ResourceLocation_): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        addVein(player: Internal.Player_, is: Internal.ItemStack_, vein: Internal.VeinRecipe_, pos: Internal.DimChunkPos_, randomMul: number): void;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        writeScreenOpeningData(player: Internal.ServerPlayer_, buf: Internal.FriendlyByteBuf_): void;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get displayName(): net.minecraft.network.chat.Component
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly DISCOVERED: "discovered";
        static readonly EXCLUDE: "exclude";
        static readonly POS_Z: "z";
        static readonly HIDE: "hide";
        static readonly DIMENSION: "dim";
        static readonly VEIN_ID: "id";
        static readonly SIZE: "size";
        static readonly POS_X: "x";
        static readonly VEINS: "veins";
        static readonly TARGET: "veinTarget";
    }
    type OreVeinAtlasItem_ = OreVeinAtlasItem;
    class AmbientMoodSettings {
        constructor($$0: Internal.Holder_<Internal.SoundEvent>, $$1: number, $$2: number, $$3: number)
        getTickDelay(): number;
        getBlockSearchExtent(): number;
        getSoundPositionOffset(): number;
        getSoundEvent(): Internal.Holder<Internal.SoundEvent>;
        get tickDelay(): number
        get blockSearchExtent(): number
        get soundPositionOffset(): number
        get soundEvent(): Internal.Holder<Internal.SoundEvent>
        static readonly CODEC: Internal.Codec<Internal.AmbientMoodSettings>;
        static readonly LEGACY_CAVE_SETTINGS: Internal.AmbientMoodSettings;
    }
    type AmbientMoodSettings_ = AmbientMoodSettings;
    class SerializationContext {
        constructor()
        serializeConditions($$0: Internal.LootItemCondition_[]): Internal.JsonElement;
        static readonly INSTANCE: Internal.SerializationContext;
    }
    type SerializationContext_ = SerializationContext;
    class LevelVersion {
        snapshot(): boolean;
        static parse($$0: Internal.Dynamic_<any>): Internal.LevelVersion;
        levelDataVersion(): number;
        lastPlayed(): number;
        minecraftVersionName(): string;
        minecraftVersion(): Internal.DataVersion;
    }
    type LevelVersion_ = LevelVersion;
    class FactoryGaugeDisplaySource extends Internal.ValueListDisplaySource {
        constructor()
        createEntry(level: Internal.Level_, pos: Internal.FactoryPanelPosition_): Internal.LongAttached<Internal.MutableComponent>;
    }
    type FactoryGaugeDisplaySource_ = FactoryGaugeDisplaySource;
    class Matrix3d {
        constructor()
        copy(): this;
        asXRotation(radians: number): this;
        getAsMatrix4f(): Matrix4f;
        multiply(m: Internal.Matrix3d_): this;
        asZRotation(radians: number): this;
        scale(d: number): this;
        transform(vec: Vec3d_): Vec3d;
        transpose(): this;
        asIdentity(): this;
        asYRotation(radians: number): this;
        add(matrix: Internal.Matrix3d_): this;
        get asMatrix4f(): Matrix4f
    }
    type Matrix3d_ = Matrix3d;
    class Parrot$Variant extends Internal.Enum<Internal.Parrot$Variant> implements Internal.StringRepresentable {
        static byId($$0: number): Internal.Parrot$Variant;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.Parrot$Variant[];
        getSerializedName(): string;
        static valueOf($$0: string): Internal.Parrot$Variant;
        getId(): number;
        get serializedName(): string
        get id(): number
        static readonly GRAY: Internal.Parrot$Variant;
        static readonly BLUE: Internal.Parrot$Variant;
        static readonly CODEC: Internal.Codec<Internal.Parrot$Variant>;
        static readonly RED_BLUE: Internal.Parrot$Variant;
        static readonly YELLOW_BLUE: Internal.Parrot$Variant;
        static readonly GREEN: Internal.Parrot$Variant;
    }
    type Parrot$Variant_ = "yellow_blue" | Parrot$Variant | "gray" | "blue" | "red_blue" | "green";
    class EraserItem extends Internal.AEBaseItem implements Internal.AEToolItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type EraserItem_ = EraserItem;
    class IotaTypeIota$1 extends Internal.IotaType<Internal.IotaTypeIota> {
        deserialize(tag: Internal.Tag_, world: Internal.ServerLevel_): Internal.IotaTypeIota;
    }
    type IotaTypeIota$1_ = IotaTypeIota$1;
    interface ContainerEntity extends net.minecraft.world.Container, Internal.MenuProvider {
        stopOpen($$0: Internal.Player_): void;
        tryClear($$0: any): void;
        abstract setLootTableSeed(arg0: number): void;
        addChestVehicleSaveData($$0: Internal.CompoundTag_): void;
        isChestVehicleEmpty(): boolean;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        abstract removeItem(arg0: number, arg1: number): Internal.ItemStack;
        getSlots(): number;
        abstract isRemoved(): boolean;
        abstract setChanged(): void;
        isChestVehicleStillValid($$0: Internal.Player_): boolean;
        abstract position(): Vec3d;
        abstract getContainerSize(): number;
        abstract setItem(arg0: number, arg1: Internal.ItemStack_): void;
        interactWithContainerVehicle($$0: Internal.Player_): Internal.InteractionResult;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        clearChestVehicleContent(): void;
        abstract removeItemNoUpdate(arg0: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        abstract setLootTable(arg0: ResourceLocation_): void;
        abstract clearItemStacks(): void;
        abstract getItem(arg0: number): Internal.ItemStack;
        unpackChestVehicleLootTable($$0: Internal.Player_): void;
        getChestVehicleSlot($$0: number): Internal.SlotAccess;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        chestVehicleDestroyed($$0: DamageSource_, $$1: Internal.Level_, $$2: Internal.Entity_): void;
        abstract getDisplayName(): net.minecraft.network.chat.Component;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        isEmpty(): boolean;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        abstract getItemStacks(): Internal.NonNullList<Internal.ItemStack>;
        abstract createMenu(arg0: number, arg1: Internal.Inventory_, arg2: Internal.Player_): Internal.AbstractContainerMenu;
        removeChestVehicleItem($$0: number, $$1: number): Internal.ItemStack;
        getChestVehicleItem($$0: number): Internal.ItemStack;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        shouldCloseCurrentScreen(): boolean;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        readChestVehicleSaveData($$0: Internal.CompoundTag_): void;
        getStackInSlot(slot: number): Internal.ItemStack;
        getHeight(): number;
        removeChestVehicleItemNoUpdate($$0: number): Internal.ItemStack;
        abstract getLootTableSeed(): number;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        getAllItems(): Internal.List<Internal.ItemStack>;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        abstract getLootTable(): ResourceLocation;
        setChestVehicleItem($$0: number, $$1: Internal.ItemStack_): void;
        abstract stillValid(arg0: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        abstract level(): Internal.Level;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        abstract clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        set lootTableSeed(arg0: number)
        get chestVehicleEmpty(): boolean
        get slots(): number
        get removed(): boolean
        get containerSize(): number
        get width(): number
        get maxStackSize(): number
        set lootTable(arg0: ResourceLocation_)
        get displayName(): net.minecraft.network.chat.Component
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get itemStacks(): Internal.NonNullList<Internal.ItemStack>
        get height(): number
        get lootTableSeed(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get lootTable(): ResourceLocation
        get mutable(): boolean
    }
    type ContainerEntity_ = ContainerEntity;
    class BlockIgnoreProcessor extends Internal.StructureProcessor {
        constructor($$0: Internal.List_<Internal.Block>)
        static readonly AIR: Internal.BlockIgnoreProcessor;
        static readonly STRUCTURE_BLOCK: Internal.BlockIgnoreProcessor;
        static readonly CODEC: Internal.Codec<Internal.BlockIgnoreProcessor>;
        static readonly STRUCTURE_AND_AIR: Internal.BlockIgnoreProcessor;
    }
    type BlockIgnoreProcessor_ = BlockIgnoreProcessor;
    interface MemorySegment$Scope {
        abstract hashCode(): number;
        abstract isAlive(): boolean;
        abstract equals(arg0: any): boolean;
        get alive(): boolean
    }
    type MemorySegment$Scope_ = MemorySegment$Scope;
    class PooledByteBufAllocator extends Internal.AbstractByteBufAllocator implements Internal.ByteBufAllocatorMetricProvider {
        constructor()
        constructor(arg0: boolean, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: boolean)
        constructor(arg0: boolean, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: boolean)
        constructor(arg0: boolean, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number, arg8: boolean, arg9: number)
        constructor(arg0: boolean, arg1: number, arg2: number, arg3: number, arg4: number)
        constructor(arg0: number, arg1: number, arg2: number, arg3: number)
        constructor(arg0: boolean, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: boolean, arg8: number)
        constructor(arg0: boolean, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number, arg6: number, arg7: number)
        constructor(arg0: boolean)
        pinnedDirectMemory(): number;
        /**
         * @deprecated
        */
        numDirectArenas(): number;
        static defaultNumDirectArena(): number;
        /**
         * @deprecated
        */
        freeThreadLocalCache(): void;
        /**
         * @deprecated
        */
        tinyCacheSize(): number;
        metric(): Internal.ByteBufAllocatorMetric;
        static defaultSmallCacheSize(): number;
        static defaultUseCacheForAllThreads(): boolean;
        /**
         * @deprecated
        */
        normalCacheSize(): number;
        static defaultPageSize(): number;
        static defaultMaxOrder(): number;
        /**
         * @deprecated
        */
        hasThreadLocalCache(): boolean;
        /**
         * @deprecated
        */
        directArenas(): Internal.List<Internal.PoolArenaMetric>;
        /**
         * @deprecated
        */
        numHeapArenas(): number;
        /**
         * @deprecated
        */
        smallCacheSize(): number;
        /**
         * @deprecated
        */
        static defaultTinyCacheSize(): number;
        static isDirectMemoryCacheAlignmentSupported(): boolean;
        /**
         * @deprecated
        */
        heapArenas(): Internal.List<Internal.PoolArenaMetric>;
        static defaultNumHeapArena(): number;
        pinnedHeapMemory(): number;
        static defaultPreferDirect(): boolean;
        /**
         * @deprecated
        */
        chunkSize(): number;
        static defaultNormalCacheSize(): number;
        trimCurrentThreadCache(): boolean;
        /**
         * @deprecated
        */
        numThreadLocalCaches(): number;
        dumpStats(): string;
        get directMemoryCacheAlignmentSupported(): boolean
        static readonly DEFAULT: Internal.PooledByteBufAllocator;
    }
    type PooledByteBufAllocator_ = PooledByteBufAllocator;
    class FocalPortBlock extends Internal.BaseEntityBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static getColor(world: Internal.BlockAndTintGetter_, pos: BlockPos_): number;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type FocalPortBlock_ = FocalPortBlock;
    class Book {
        constructor(root: Internal.JsonObject_, owner: Internal.XplatModContainer_, id: ResourceLocation_, external: boolean)
        getOwnerName(): string;
        markUpdated(): void;
        getSubtitle(): Internal.MutableComponent;
        reloadLocks(suppressToasts: boolean): void;
        getFontStyle(): Internal.Style;
        reloadContents(level: Internal.Level_, singleBook: boolean): void;
        getBookItem(): Internal.ItemStack;
        advancementsEnabled(): boolean;
        getContents(): Internal.BookContents;
        popUpdated(): boolean;
        getIcon(): Internal.BookIcon;
        get ownerName(): string
        get subtitle(): Internal.MutableComponent
        get fontStyle(): Internal.Style
        get bookItem(): Internal.ItemStack
        get contents(): Internal.BookContents
        get icon(): Internal.BookIcon
        readonly macros: Internal.Map<string, string>;
        readonly version: string;
        readonly creativeTab: ResourceLocation;
        readonly linkHoverColor: number;
        readonly useBlockyFont: boolean;
        readonly linkColor: number;
        readonly headerColor: number;
        readonly overflowMode: Internal.PatchouliConfigAccess$TextOverflowMode;
        readonly i18n: boolean;
        readonly craftingTexture: ResourceLocation;
        readonly textColor: number;
        readonly subtitle: string;
        readonly flipSound: ResourceLocation;
        readonly isExternal: boolean;
        readonly showToasts: boolean;
        readonly openSound: ResourceLocation;
        readonly showProgress: boolean;
        readonly id: ResourceLocation;
        readonly landingText: string;
        readonly model: ResourceLocation;
        readonly bookTexture: ResourceLocation;
        readonly name: string;
        readonly progressBarColor: number;
        readonly fillerTexture: ResourceLocation;
        readonly progressBarBackground: number;
        readonly pauseGame: boolean;
        readonly advancementsTab: ResourceLocation;
        readonly noBook: boolean;
        readonly indexIconRaw: string;
        readonly isPamphlet: boolean;
        readonly nameplateColor: number;
        readonly owner: Internal.XplatModContainer;
    }
    type Book_ = Book;
    interface AgriAllele <T> {
        abstract gene(): Internal.AgriGene<T>;
        abstract isDominant(arg0: Internal.AgriAllele_<T>): boolean;
        abstract trait(): T;
    }
    type AgriAllele_<T> = AgriAllele<T>;
    class BlockPodium extends Internal.BaseEntityBlock {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BlockPodium_ = BlockPodium;
    interface Int2LongFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.IntToLongFunction {
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2LongFunction;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2LongFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        getOrDefault(arg0: number, arg1: number): number;
        andThenReference<T>(arg0: Internal.Long2ReferenceFunction_<T>): Internal.Int2ReferenceFunction<T>;
        containsKey(arg0: number): boolean;
        composeInt(arg0: Internal.Int2IntFunction_): this;
        andThenFloat(arg0: Internal.Long2FloatFunction_): Internal.Int2FloatFunction;
        andThenDouble(arg0: Internal.Long2DoubleFunction_): Internal.Int2DoubleFunction;
        apply(arg0: number): number;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenLong(arg0: Internal.Long2LongFunction_): this;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenShort(arg0: Internal.Long2ShortFunction_): Internal.Int2ShortFunction;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2LongFunction;
        remove(arg0: number): number;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2LongFunction;
        defaultReturnValue(): number;
        andThenChar(arg0: Internal.Long2CharFunction_): Internal.Int2CharFunction;
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenInt(arg0: Internal.Long2IntFunction_): Internal.Int2IntFunction;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        size(): number;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2LongFunction;
        applyAsLong(arg0: number): number;
        clear(): void;
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2LongFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        abstract get(arg0: number): number;
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2LongFunction<T>;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        andThenObject<T>(arg0: Internal.Long2ObjectFunction_<T>): Internal.Int2ObjectFunction<T>;
        identity<T>(): Internal.Function<T, T>;
        andThenByte(arg0: Internal.Long2ByteFunction_): Internal.Int2ByteFunction;
        defaultReturnValue(arg0: number): void;
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2LongFunction;
        (arg0: number): number;
    }
    type Int2LongFunction_ = Int2LongFunction;
    interface MenuRegistry$ScreenFactory <H extends Internal.AbstractContainerMenu, S extends Internal.Screen & Internal.MenuAccess<H>> {
        abstract create(arg0: H, arg1: Internal.Inventory_, arg2: net.minecraft.network.chat.Component_): S;
        (arg0: H, arg1: Internal.Inventory, arg2: net.minecraft.network.chat.Component): S;
    }
    type MenuRegistry$ScreenFactory_<H extends Internal.AbstractContainerMenu, S extends Internal.Screen & Internal.MenuAccess<H>> = MenuRegistry$ScreenFactory<H, S>;
    abstract class ClientboundMoveEntityPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        handle(arg0: Internal.PacketListener_): void;
        abstract write(arg0: Internal.FriendlyByteBuf_): void;
        getxRot(): number;
        getyRot(): number;
        getEntity($$0: Internal.Level_): Internal.Entity;
        hasPosition(): boolean;
        isSkippable(): boolean;
        getXa(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getZa(): number;
        getYa(): number;
        hasRotation(): boolean;
        isOnGround(): boolean;
        get xRot(): number
        get yRot(): number
        get skippable(): boolean
        get xa(): number
        get za(): number
        get ya(): number
        get onGround(): boolean
    }
    type ClientboundMoveEntityPacket_ = ClientboundMoveEntityPacket;
    class BitwiseSetArithmetic implements Internal.Arithmetic {
        getOperator(pattern: Internal.HexPattern_): Internal.Operator;
        opTypes(): Internal.List<Internal.HexPattern>;
        arithName(): string;
        static readonly INSTANCE: Internal.BitwiseSetArithmetic;
    }
    type BitwiseSetArithmetic_ = BitwiseSetArithmetic;
    interface CopyableComponent <C extends dev.onyxstudios.cca.api.v3.component.Component> extends dev.onyxstudios.cca.api.v3.component.Component {
        abstract readFromNbt(arg0: Internal.CompoundTag_): void;
        abstract writeToNbt(arg0: Internal.CompoundTag_): void;
        abstract equals(arg0: any): boolean;
        abstract copyFrom(arg0: C): void;
    }
    type CopyableComponent_<C extends dev.onyxstudios.cca.api.v3.component.Component> = CopyableComponent<C>;
    interface TickablePacketListener extends Internal.PacketListener {
        abstract isAcceptingMessages(): boolean;
        abstract onDisconnect(arg0: net.minecraft.network.chat.Component_): void;
        abstract tick(): void;
        shouldPropagateHandlingExceptions(): boolean;
        get acceptingMessages(): boolean
    }
    type TickablePacketListener_ = TickablePacketListener;
    class LevelChunk extends Internal.ChunkAccess implements Internal.LevelHeightAccessor, Internal.ComponentProvider, Internal.ExtendedChunk, Internal.LevelChunkAccess {
        constructor($$0: Internal.Level_, $$1: Internal.ChunkPos_)
        constructor($$0: Internal.ServerLevel_, $$1: Internal.ProtoChunk_, $$2: Internal.LevelChunk$PostLoadProcessor_)
        constructor($$0: Internal.Level_, $$1: Internal.ChunkPos_, $$2: Internal.UpgradeData_, $$3: Internal.LevelChunkTicks_<Internal.Block>, $$4: Internal.LevelChunkTicks_<Internal.Fluid>, $$5: number, $$6: Internal.LevelChunkSection_[], $$7: Internal.LevelChunk$PostLoadProcessor_, $$8: Internal.BlendingData_)
        clearAllBlockEntities(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<Internal.Biome>;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        setLoaded($$0: boolean): void;
        static create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        "handler$cck000$fabric-data-attachment-api-v1$transferProtoChunkAttachement"(world: Internal.ServerLevel_, protoChunk: Internal.ProtoChunk_, entityLoader: Internal.LevelChunk$PostLoadProcessor_, ci: Internal.CallbackInfo_): void;
        handler$zch000$porting_lib_base$port_lib$addPendingBlockEntities(ci: Internal.CallbackInfo_): void;
        registerAllBlockEntitiesAfterLevelLoad(): void;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getFluidState(x: number, y: number, z: number): Internal.FluidState;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        asComponentProvider(): Internal.ComponentProvider;
        addAndRegisterBlockEntity($$0: Internal.BlockEntity_): void;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        "handler$edo000$lib39-phantom$lib39Phantom$getFluidState"(pos: BlockPos_, ci: Internal.CallbackInfoReturnable_<any>): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        replaceWithPacketData($$0: Internal.FriendlyByteBuf_, $$1: Internal.CompoundTag_, $$2: Internal.Consumer_<Internal.ClientboundLevelChunkPacketData$BlockEntityTagOutput>): void;
        unregisterTickContainerFromLevel($$0: Internal.ServerLevel_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        csa$getStorage(): Internal.DataStorage;
        handler$zch000$porting_lib_base$port_lib$onBlockEntityLoad(blockEntity: Internal.BlockEntity_, ci: Internal.CallbackInfo_): void;
        getBlockEntity($$0: BlockPos_, $$1: Internal.LevelChunk$EntityCreationType_): Internal.BlockEntity;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        getBlockEntityRenderData(pos: BlockPos_): any;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getLevel(): Internal.Level;
        unpackTicks($$0: number): void;
        "handler$edo000$lib39-phantom$lib39Phantom$getBlockEntity"(pos: BlockPos_, creationType: Internal.LevelChunk$EntityCreationType_, ci: Internal.CallbackInfoReturnable_<any>): void;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        runPostLoad(): void;
        postProcessGeneration(): void;
        getFullStatus(): Internal.FullChunkStatus;
        "handler$edo000$lib39-phantom$lib39Phantom$getBlockState"(pos: BlockPos_, ci: Internal.CallbackInfoReturnable_<any>): void;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        handler$hio000$starlight$onConstruct(level: Internal.Level_, chunkPos: Internal.ChunkPos_, upgradeData: Internal.UpgradeData_, levelChunkTicks: Internal.LevelChunkTicks_<any>, levelChunkTicks2: Internal.LevelChunkTicks_<any>, l: number, levelChunkSections: Internal.LevelChunkSection_[], postLoadProcessor: Internal.LevelChunk$PostLoadProcessor_, blendingData: Internal.BlendingData_, ci: Internal.CallbackInfo_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        getRecipientsForComponentSync(): Internal.Iterable<any>;
        setFullStatus($$0: Internal.Supplier_<Internal.FullChunkStatus>): void;
        registerTickContainerInLevel($$0: Internal.ServerLevel_): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        handler$hio000$starlight$onTransitionToFull(serverLevel: Internal.ServerLevel_, protoChunk: Internal.ProtoChunk_, postLoadProcessor: Internal.LevelChunk$PostLoadProcessor_, ci: Internal.CallbackInfo_): void;
        replaceBiomes($$0: Internal.FriendlyByteBuf_): void;
        hasBiomes(): boolean;
        getBlockEntities(): Internal.Map<BlockPos, Internal.BlockEntity>;
        getMaxLightLevel(): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        static traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        set loaded($$0: boolean)
        get empty(): boolean
        get level(): Internal.Level
        get fullStatus(): Internal.FullChunkStatus
        get recipientsForComponentSync(): Internal.Iterable<any>
        set fullStatus($$0: Internal.Supplier_<Internal.FullChunkStatus>)
        get blockEntities(): Internal.Map<BlockPos, Internal.BlockEntity>
        get maxLightLevel(): number
    }
    type LevelChunk_ = LevelChunk;
    class FleshTendonFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        placeFleshTendonColumn(p_67377_: Internal.WorldGenLevel_, p_67378_: Internal.RandomSource_, p_67379_: BlockPos_): void;
        generateFleshBall(world: Internal.WorldGenLevel_, pos: BlockPos_, rand: Internal.RandomSource_): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_, flags: number): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type FleshTendonFeature_ = FleshTendonFeature;
    class User$Type extends Internal.Enum<Internal.User$Type> {
        getName(): string;
        static valueOf($$0: string): Internal.User$Type;
        static byName($$0: string): Internal.User$Type;
        static values(): Internal.User$Type[];
        get name(): string
        static readonly LEGACY: Internal.User$Type;
        static readonly MSA: Internal.User$Type;
        static readonly MOJANG: Internal.User$Type;
    }
    type User$Type_ = User$Type | "mojang" | "msa" | "legacy";
    class CookingPotRecipe$Serializer implements Internal.RecipeSerializer<Internal.CookingPotRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: Internal.CookingPotRecipe_): void;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromJson(recipeId: ResourceLocation_, json: Internal.JsonObject_): Internal.CookingPotRecipe;
        fromNetwork(recipeId: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): Internal.CookingPotRecipe;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type CookingPotRecipe$Serializer_ = CookingPotRecipe$Serializer;
    interface RenderMaterial extends Internal.MaterialView {
        abstract emissive(): boolean;
        /**
         * @deprecated
        */
        spriteDepth(): number;
        abstract disableDiffuse(): boolean;
        abstract ambientOcclusion(): Internal.TriState;
        abstract glint(): Internal.TriState;
        abstract disableColorIndex(): boolean;
        abstract blendMode(): net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
        readonly MATERIAL_STANDARD: ResourceLocation;
    }
    type RenderMaterial_ = RenderMaterial;
    class RedstoneWallTorchBlock extends Internal.RedstoneTorchBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
        static readonly LIT: Internal.BooleanProperty;
    }
    type RedstoneWallTorchBlock_ = RedstoneWallTorchBlock;
}
declare namespace net.blay09.mods.balm.mixin {
    interface MouseHandlerAccessor {
        abstract getMouseX(): number;
        abstract getMouseY(): number;
        get mouseX(): number
        get mouseY(): number
    }
    type MouseHandlerAccessor_ = MouseHandlerAccessor;
    interface SlotAccessor {
        abstract setY(arg0: number): void;
        abstract setX(arg0: number): void;
        set y(arg0: number)
        set x(arg0: number)
    }
    type SlotAccessor_ = SlotAccessor;
}
